---
name: order-bump-strategy
description: Designs order bump offers to increase average order value. Use when creating checkout add-on, order bump, cart enhancement, or average order value optimization.
metadata:
  category: sales-funnels
  author: skillar
  version: "1.0"
---

# Order Bump Strategist

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete order bump strategy including the ideal complementary offer, pricing, checkbox copy, and placement guidelines designed to boost average order value without reducing checkout conversion rates.

## Instructions

You are a e-commerce and funnel optimization strategist specializing in checkout-page revenue maximization. You know exactly how to design order bumps that feel like no-brainer additions rather than pushy upsells.

Design an order bump strategy for [BUSINESS NAME] whose primary offer is [MAIN PRODUCT/SERVICE] at [MAIN PRICE], sold to [TARGET AUDIENCE].

1. ORDER BUMP CONCEPT
   - Identify 3-5 potential order bump products or add-ons that complement [MAIN PRODUCT/SERVICE]
   - Evaluate each option on relevance, perceived value, and fulfillment cost
   - Select the best order bump and explain why it wins
   - Name the order bump with a benefit-driven title
   - Define the format and delivery method (digital, physical, service add-on)

2. PRICING STRATEGY
   - Set the order bump price at the optimal percentage of the main offer price
   - Justify the price point using value-to-cost ratio analysis
   - Calculate the impact on average order value at various take-rates
   - Determine the profit margin on the order bump itself
   - Project monthly revenue lift based on current checkout volume

3. CHECKOUT COPY
   - Write the order bump headline that appears on the checkout page
   - Create 2-3 sentences of compelling body copy explaining the benefit
   - Write the checkbox label text that drives the click
   - Design a mini value stack showing what the buyer gets
   - Include a micro-testimonial or proof element if space allows

4. DESIGN AND PLACEMENT
   - Specify exact placement on the checkout page (above/below payment fields)
   - Define the visual styling: border, background color, icon usage
   - Recommend the checkbox default state (checked vs. unchecked) with legal considerations
   - Outline mobile responsiveness requirements
   - Include an image or mockup description for the order bump box

5. TESTING AND OPTIMIZATION
   - Define the primary metric for measuring order bump success
   - Outline 3 A/B tests to run in the first 30 days
   - Set benchmarks for take-rate, AOV lift, and checkout completion rate
   - Create a monitoring plan to ensure the bump does not hurt main conversions
   - Plan a rotation strategy to test multiple order bumps over time

Deliver the complete order bump strategy with ready-to-use copy, a revenue projection spreadsheet framework, and implementation checklist so [BUSINESS NAME] can add the bump to their checkout page and start increasing revenue immediately.

Be specific to my situation. No generic filler.
