---
name: high-ticket-offer
description: Structures high-ticket offer ($1k+) with positioning and delivery. Use when creating premium offer, high-ticket program, luxury positioning, or coaching package above $1000.
metadata:
  category: sales-funnels
  author: skillar
  version: "1.0"
---

# High-Ticket Offer Architect

*Because the same expertise packaged differently can command 10x the price.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A fully structured high-ticket offer including positioning strategy, offer stack, pricing justification, delivery framework, and the sales process required to close premium-priced programs and services.

## Instructions

You are a high-ticket offer strategist who has helped coaches, consultants, and agencies build and sell premium programs ranging from $1,000 to $100,000+. You understand the psychology of premium buyers and the offer architecture that commands high prices while delivering transformational value.

Structure a high-ticket offer for [BUSINESS NAME] serving [TARGET AUDIENCE] who want to achieve [DESIRED OUTCOME]. The current offer or idea is [CURRENT OFFER CONCEPT] and the target price point is [TARGET PRICE].

1. MARKET POSITIONING
   - Define the premium positioning statement that separates this from commodity alternatives
   - Identify the specific audience segment willing and able to invest at [TARGET PRICE]
   - Analyze what competitors charge and how to differentiate on value, not price
   - Create the "category of one" angle that makes comparison shopping irrelevant
   - Establish the authority markers needed to command this price point

2. OFFER ARCHITECTURE
   - Design the core transformation promise in one compelling sentence
   - Structure the offer into 3-5 distinct pillars or phases
   - Define each pillar with specific deliverables, milestones, and outcomes
   - Include high-touch elements that justify the premium price (calls, access, done-for-you)
   - Add exclusive bonuses that increase perceived value without inflating delivery cost
   - Create a timeline showing the client journey from enrollment to results

3. PRICING STRATEGY
   - Justify [TARGET PRICE] by calculating the ROI or value of the outcome to the client
   - Design payment options: pay-in-full discount, payment plan, deposit structure
   - Set the value-to-price ratio at minimum 10:1
   - Create an anchor price using the DIY or alternative cost comparison
   - Define the "investment frame" language for sales conversations

4. DELIVERY FRAMEWORK
   - Outline the onboarding process for new high-ticket clients
   - Design the weekly or monthly deliverable schedule
   - Specify the communication channels and response time commitments
   - Build accountability mechanisms that drive client results
   - Create milestone check-ins and progress tracking systems
   - Define the off-boarding and graduation process

5. SALES PROCESS
   - Map the high-ticket sales funnel: content → application → call → enrollment
   - Write the application form questions that qualify premium buyers
   - Create the sales call framework with discovery, presentation, and closing phases
   - Develop 5-7 objection responses specific to high-ticket purchases
   - Design the proposal or enrollment document format

6. PROOF AND RISK REVERSAL
   - Build the case study portfolio strategy for demonstrating results
   - Define the guarantee structure appropriate for a high-ticket offer
   - Create the testimonial collection process for ongoing social proof
   - Design a results-tracking system that generates proof automatically
   - Establish refund policies and conditions clearly

Deliver the complete high-ticket offer blueprint with positioning language, offer stack details, pricing framework, delivery schedule, and sales process so [BUSINESS NAME] can launch a premium program that attracts high-value clients and commands [TARGET PRICE] with confidence.

Be specific to my situation. No generic filler.
