---
name: free-trial-funnel
description: Designs free trial funnel with activation and conversion touchpoints. Use when creating trial offer, freemium funnel, SaaS trial strategy, or try-before-you-buy conversion path.
metadata:
  category: sales-funnels
  author: skillar
  version: "1.0"
---

# Free Trial Funnel Designer

*Because a free trial without onboarding is just a free demo of confusion.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete free trial funnel with sign-up page, onboarding sequence, activation milestones, conversion touchpoints, and the communication strategy that maximizes trial-to-paid conversion rates.

## Instructions

You are a SaaS and subscription funnel strategist who specializes in free trial optimization. You understand the critical activation metrics, onboarding psychology, and communication timing that turn trial users into long-term paying customers.

Design a free trial funnel for [PRODUCT NAME] by [BUSINESS NAME], a [PRODUCT TYPE] priced at [MONTHLY/ANNUAL PRICE] targeting [TARGET AUDIENCE]. The trial duration is [TRIAL LENGTH] days.

1. TRIAL OFFER STRUCTURE
   - Define the trial type (freemium, time-limited full access, feature-limited, credit-based)
   - Determine whether to require a credit card at sign-up with pros and cons
   - Specify exactly what features and limits the trial includes
   - Create a compelling trial offer headline and value proposition
   - Set expectations for what happens when the trial ends

2. SIGN-UP PAGE
   - Write the headline focusing on the outcome, not the trial itself
   - List 3-5 key benefits the user will experience during the trial
   - Minimize sign-up friction with optimal form field selection
   - Include trust signals: security badges, no-commitment language, social proof
   - Write CTA button copy that emphasizes starting, not buying
   - Add a brief FAQ addressing trial concerns

3. ONBOARDING SEQUENCE
   - Define the "aha moment" — the key action that correlates with conversion
   - Design Day 1 welcome email with a single clear next step
   - Create an in-app or email onboarding checklist of 3-5 activation steps
   - Map the ideal first-session experience that delivers immediate value
   - Build progressive onboarding that reveals features as the user advances
   - Include a personal touch (founder video, welcome call offer) for high-value segments

4. ACTIVATION MILESTONES
   - Identify 3-5 activation events that predict conversion to paid
   - Design triggered emails or in-app messages for each milestone achieved
   - Create intervention sequences when users miss key milestones
   - Set Day 1, Day 3, and mid-trial engagement benchmarks
   - Build a health score model that flags at-risk trial users

5. CONVERSION COMMUNICATION
   - Design the mid-trial check-in that reinforces value received so far
   - Create the 3-day-before-expiry urgency sequence
   - Write the trial-ending email with a clear upgrade CTA and incentive
   - Develop a special offer for trial users who need an extra push
   - Plan the post-expiry win-back sequence for non-converters

6. METRICS AND OPTIMIZATION
   - Define the core trial funnel metrics: sign-up rate, activation rate, conversion rate
   - Set benchmarks for each metric based on industry standards
   - Identify the top 3 levers for improving trial-to-paid conversion
   - Design an A/B testing roadmap for the first 90 days
   - Create a cohort analysis framework to track improvements over time

Deliver the complete free trial funnel with all page copy, email sequences, activation milestone definitions, and a metrics dashboard template so [BUSINESS NAME] can launch and optimize a high-converting trial experience.

Be specific to my situation. No generic filler.
