---
name: follow-up-sequence
description: Designs follow-up sequence for leads who did not convert. Use when creating nurture sequence, re-engagement emails, lead follow-up, or sales cadence for unconverted prospects.
metadata:
  category: sales-funnels
  author: skillar
  version: "1.0"
---

# Follow-Up Sequence Designer

*Because persistence wins deals. Pushiness loses them. The line is thinner than you think.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete multi-touch follow-up sequence with email copy, timing strategy, channel mix, and escalation triggers — designed to re-engage leads who showed interest but did not purchase.

## Instructions

You are a sales follow-up strategist who understands that most sales happen after the 5th to 12th touchpoint. You specialize in designing persistent-but-respectful follow-up sequences that keep your brand top of mind and convert leads who were not ready to buy on first contact.

Design a follow-up sequence for [BUSINESS NAME] targeting leads who expressed interest in [PRODUCT/SERVICE] at [PRICE] but did not convert. The target audience is [TARGET AUDIENCE].

1. LEAD SEGMENTATION
   - Define 3-4 segments based on where leads dropped off in the funnel
   - Categorize leads by engagement level: hot (viewed pricing), warm (consumed content), cool (opted in only)
   - Identify the likely reason for non-conversion in each segment
   - Set different follow-up intensities and angles for each segment
   - Define the criteria for moving leads between segments based on behavior

2. IMMEDIATE FOLLOW-UP (Days 1-3)
   - Write Email 1 (Day 0): Acknowledge their interest without being desperate
   - Write Email 2 (Day 1): Share a relevant case study or success story
   - Write Email 3 (Day 3): Address the most common objection with proof
   - Include subject lines optimized for open rates
   - Define the tone: helpful, not salesy; persistent, not pushy

3. VALUE-BUILDING PHASE (Days 4-14)
   - Write Email 4 (Day 5): Deliver unexpected value with a free resource or tip
   - Write Email 5 (Day 7): Share a different angle or use case for [PRODUCT/SERVICE]
   - Write Email 6 (Day 10): Send a "what others are saying" social proof compilation
   - Write Email 7 (Day 14): Present a limited-time incentive or bonus offer
   - Include engagement triggers that escalate hot leads to direct outreach

4. LONG-TERM NURTURE (Days 15-60)
   - Design a bi-weekly email cadence with alternating content types
   - Write 4 nurture emails mixing education, storytelling, and soft promotion
   - Include re-engagement subject lines for leads who stop opening
   - Add a "break-up" email at Day 45 that creates urgency through potential loss
   - Define content themes that keep [PRODUCT/SERVICE] relevant without repeating

5. MULTI-CHANNEL TOUCHPOINTS
   - Design retargeting ad themes that complement the email sequence
   - Create SMS or direct message templates for high-value leads
   - Plan a personal video or voice message for top-tier prospects
   - Outline social media engagement tactics for leads who follow your accounts
   - Define the channel escalation path based on lead value and engagement

6. METRICS AND OPTIMIZATION
   - Set benchmarks for open rate, reply rate, and conversion rate per email
   - Define the "win-back conversion rate" target for the overall sequence
   - Identify which emails to A/B test first for maximum impact
   - Create a sunset policy for truly unresponsive leads
   - Build a reporting dashboard to track sequence performance weekly

Deliver the complete follow-up sequence with all email copy, subject lines, timing schedule, and multi-channel touchpoints so [BUSINESS NAME] can systematically convert leads who were not ready to buy on the first interaction.

Be specific to my situation. No generic filler.
