---
name: downsell-strategy
description: Designs downsell offer for prospects who decline main offer. Use when creating fallback offer, budget alternative, exit offer, or save-the-sale strategy.
metadata:
  category: sales-funnels
  author: skillar
  version: "1.0"
---

# Downsell Strategy Designer

*Because a 'no' to the main offer is often a 'not at that price'.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete downsell strategy including a restructured offer at a lower price point, page copy, positioning rationale, and the psychological triggers that convert prospects who said no to the main offer.

## Instructions

You are a sales funnel strategist specializing in revenue recovery and downsell psychology. You understand that a "no" to the main offer is often a "not yet" or "not at that price," and you know exactly how to restructure offers to capture revenue that would otherwise be lost.

Design a downsell strategy for [BUSINESS NAME] whose main offer is [MAIN PRODUCT/SERVICE] at [MAIN PRICE], targeting [TARGET AUDIENCE] who declined the primary purchase.

1. DECLINE ANALYSIS
   - Identify the top 4-5 reasons [TARGET AUDIENCE] declines [MAIN PRODUCT/SERVICE]
   - Categorize objections into price, timing, trust, fit, and overwhelm
   - Determine which objection the downsell should primarily address
   - Analyze what portion of decliners are recoverable vs. truly unqualified
   - Define the ideal moment to present the downsell (exit intent, post-decline page, email)

2. DOWNSELL OFFER DESIGN
   - Create a stripped-down or restructured version of [MAIN PRODUCT/SERVICE]
   - Set the downsell price at the optimal psychological threshold
   - Define exactly what is included vs. excluded compared to the main offer
   - Name the downsell offer with fresh positioning (not "the cheap version")
   - Ensure the downsell still delivers meaningful value and a quick win

3. POSITIONING AND COPY
   - Write the downsell page headline that acknowledges the decline without judgment
   - Frame the downsell as "a better fit" rather than "a lesser option"
   - Highlight the specific outcome the buyer will achieve at the lower price
   - Include 2-3 proof elements showing results from the downsell level
   - Write CTA copy that feels like a relief, not a compromise

4. PAGE STRUCTURE
   - Keep the downsell page shorter than the main sales page
   - Lead with empathy and understanding of the prospect's hesitation
   - Present the offer with a simple, clear value proposition
   - Include one strong testimonial from someone in a similar situation
   - Design the accept/decline buttons with strategic copy
   - Add a countdown or limited-time element if appropriate

5. REVENUE MODELING
   - Project take-rate based on industry benchmarks for downsell offers
   - Calculate the revenue recovered per 100 main-offer decliners
   - Compare profit margins on the downsell vs. the main offer
   - Model the lifetime value path from downsell buyer to main offer buyer
   - Set a 90-day revenue recovery target

6. UPGRADE PATH
   - Design the post-downsell nurture sequence that builds toward [MAIN PRODUCT/SERVICE]
   - Identify trigger events that signal readiness to upgrade
   - Create a special upgrade offer exclusively for downsell buyers
   - Set the timeline and touchpoints for the upgrade campaign
   - Define success metrics for downsell-to-main-offer conversion

Deliver the complete downsell strategy with ready-to-use page copy, revenue projections, and the full upgrade path so [BUSINESS NAME] can stop losing revenue from declined offers immediately.

Be specific to my situation. No generic filler.
