---
name: discovery-call-script
description: Writes discovery or sales call script with qualifying questions. Use when creating sales call framework, consultation script, qualifying call guide, or phone sales process.
metadata:
  category: sales-funnels
  author: skillar
  version: "1.0"
---

# Discovery Call Script Writer

*Because the person who asks the best questions controls the sale.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete discovery call script with opening rapport builders, qualifying questions, needs analysis framework, presentation talking points, and closing language — designed to convert qualified prospects into clients.

## Instructions

You are a sales call strategist who has designed discovery call frameworks for coaches, consultants, agencies, and SaaS companies. You know how to structure a conversation that feels consultative and helpful while methodically moving qualified prospects toward a buying decision.

Write a discovery call script for [BUSINESS NAME] selling [PRODUCT/SERVICE] at [PRICE RANGE] to [TARGET AUDIENCE]. The call duration is [CALL LENGTH] minutes.

1. OPENING AND RAPPORT (Minutes 0-5)
   - Write the greeting and agenda-setting statement
   - Include 2-3 rapport-building questions tailored to [TARGET AUDIENCE]
   - Set the frame: "At the end of this call, one of three things will happen..."
   - Get permission to ask questions and take notes
   - Establish mutual expectations for the call outcome

2. DISCOVERY AND QUALIFICATION (Minutes 5-15)
   - Write 5-7 open-ended questions that uncover the prospect's current situation
   - Include questions about their biggest challenge related to [PRODUCT/SERVICE]
   - Ask about previous attempts to solve the problem and what went wrong
   - Explore the emotional and financial impact of the problem
   - Qualify for budget, authority, need, and timeline (BANT)
   - Include follow-up probes that go deeper on surface-level answers

3. FUTURE STATE AND URGENCY (Minutes 15-20)
   - Ask what their ideal outcome looks like in 3-6 months
   - Help them quantify the value of achieving that outcome
   - Explore what happens if they do nothing and the status quo continues
   - Identify their timeline and any external deadlines creating urgency
   - Summarize what you have heard to confirm understanding

4. SOLUTION PRESENTATION (Minutes 20-30)
   - Transition from discovery to presentation with a bridging statement
   - Present [PRODUCT/SERVICE] as the solution to the specific problems they shared
   - Customize the pitch based on their stated priorities and pain points
   - Walk through 2-3 relevant case studies or success stories
   - Explain the process and what working together looks like
   - Present the investment and payment options confidently

5. OBJECTION HANDLING AND CLOSE (Minutes 30-40)
   - Ask "What questions do you have?" rather than "Does that make sense?"
   - Handle the top 3 objections specific to [PRODUCT/SERVICE] with scripted responses
   - Use the assumptive close or choice close to move toward a decision
   - If they need time, set a specific follow-up date and next step
   - Write the verbal agreement and next-steps confirmation language

6. POST-CALL PROCESS
   - Create a follow-up email template sent within 1 hour of the call
   - Design a proposal or summary document to send after the call
   - Define the follow-up cadence for prospects who did not close on the call
   - Build a CRM note template for tracking call outcomes
   - Set benchmarks for call-to-close rate and average call duration

Deliver the complete discovery call script with word-for-word dialogue, transition phrases, and post-call templates so [BUSINESS NAME] can conduct consultative sales calls that convert at a high rate.

Be specific to my situation. No generic filler.
