---
name: demo-script
description: Creates product demo script that highlights value and handles objections. Use when writing demo presentation, product walkthrough, software demo, or sales demonstration script.
metadata:
  category: sales-funnels
  author: skillar
  version: "1.0"
---

# Product Demo Script Creator

*Because a demo is not a feature tour — it's a value-selling conversation.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete product demo script with opening hook, feature-to-benefit walkthrough, objection handling, competitive differentiation, and closing sequence — structured to convert demo attendees into customers.

## Instructions

You are a product demo strategist and sales engineer who has designed and delivered high-converting product demonstrations for SaaS companies, physical products, and service businesses. You understand that a demo is not a feature tour but a value-selling conversation disguised as a product walkthrough.

Create a product demo script for [PRODUCT NAME] by [BUSINESS NAME], targeting [TARGET AUDIENCE] who currently deal with [KEY PAIN POINT]. The demo duration is [DEMO LENGTH] minutes and the product is priced at [PRICE].

1. PRE-DEMO PREPARATION
   - Define 3-5 discovery questions to ask before the demo to customize the presentation
   - Create a prospect research checklist to personalize the demo
   - Prepare the demo environment with relevant sample data matching the prospect's use case
   - Identify the decision-maker and influencer roles likely on the call
   - Set the demo agenda and share it with attendees beforehand
   - Outline the technical requirements and backup plan if technology fails

2. OPENING HOOK (First 3 Minutes)
   - Write the opening statement that acknowledges the prospect's specific challenge
   - Summarize what you learned in discovery and confirm priorities
   - Set expectations for the demo structure and timing
   - Promise the one big outcome they will see during the demo
   - Get agreement on evaluation criteria before starting the walkthrough

3. VALUE-DRIVEN WALKTHROUGH (Core Demo)
   - Structure the demo around 3-4 use cases, not features
   - For each use case, follow the pattern: problem → solution → result
   - Script the transition language between each use case
   - Highlight the "wow moments" that create emotional reactions
   - Include pause points to check in and ask "How does this compare to your current process?"
   - Demonstrate the ease of use without rushing through complexity

4. COMPETITIVE DIFFERENTIATION
   - Identify the top 2-3 competitors the prospect is likely evaluating
   - Prepare subtle comparison points that highlight unique advantages
   - Script the language for "What makes us different" without badmouthing competitors
   - Demonstrate 1-2 features or capabilities competitors cannot match
   - Address the "why not just use [competitor]" question preemptively

5. OBJECTION HANDLING DURING DEMO
   - Prepare responses for "This looks complicated" with simplicity proof
   - Handle "Our team won't adopt this" with change management and onboarding examples
   - Address "How long until we see results?" with implementation timeline and quick wins
   - Counter "We've seen similar tools before" with differentiation and proof
   - Script the response for "Can you do [specific feature request]?" including honest answers
   - Include customer success stories to reinforce each objection response

6. CLOSING AND NEXT STEPS
   - Write the demo summary highlighting the key value points discussed
   - Ask the evaluation question: "Based on what you've seen, how well does this address your needs?"
   - Present the pricing and packaging appropriate to their situation
   - Propose a clear next step: trial, pilot, proposal, or sign-up
   - Script the follow-up email template to send within 2 hours of the demo
   - Define the handoff process from demo to onboarding

Deliver the complete demo script with word-for-word dialogue, screen-by-screen direction notes, and a post-demo follow-up template so [BUSINESS NAME]'s team can deliver demos that consistently convert prospects into customers.

Be specific to my situation. No generic filler.
