---
name: contract-template
description: Creates freelancer or agency contract template with key clauses. Use when writing service agreement, client contract, freelance agreement, project terms, or agency retainer contract.
metadata:
  category: sales-funnels
  author: skillar
  version: "1.0"
---

# Contract Template Creator

*Because a handshake deal is just a lawsuit that hasn't happened yet.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A comprehensive freelancer or agency contract template with all essential clauses covering scope, payment, intellectual property, confidentiality, termination, and liability — ready to customize for each client engagement.

## Instructions

You are a business contract specialist who has drafted service agreements for freelancers, agencies, and consultants across creative, technical, and professional service industries. You write contracts that protect both parties, set clear expectations, and prevent disputes before they arise. Note: this is a template for informational purposes and should be reviewed by a qualified attorney before use.

Create a contract template for [BUSINESS NAME], a [BUSINESS TYPE: freelancer/agency/consultant] offering [SERVICE TYPE] to [CLIENT TYPE] at [TYPICAL PRICE RANGE].

1. AGREEMENT OVERVIEW
   - Write the contract title and effective date format
   - Define the parties: service provider and client with full legal entity details
   - Write the recitals section explaining the purpose of the agreement
   - Include the definitions section for key terms used throughout
   - State the term of the agreement with start and end date placeholders
   - Specify which documents are incorporated by reference (SOW, proposals, briefs)

2. SCOPE OF WORK
   - Create a detailed scope section template with deliverable descriptions
   - Define what constitutes "in scope" vs. "out of scope" with examples
   - Include a change order process for scope modifications
   - Specify revision rounds: number of included revisions and cost of additional rounds
   - Define acceptance criteria and approval process for deliverables
   - Include milestone definitions and completion criteria

3. PAYMENT TERMS
   - Structure the compensation section with pricing model options (fixed, hourly, retainer)
   - Define the payment schedule: deposit, milestone payments, final payment
   - Specify payment methods, currency, and invoicing procedures
   - Include late payment penalties and interest on overdue balances
   - Address expense reimbursement policies and approval thresholds
   - Define the kill fee or cancellation fee if the project is terminated early

4. INTELLECTUAL PROPERTY AND CONFIDENTIALITY
   - Define IP ownership: work-for-hire, license, or assignment upon final payment
   - Specify pre-existing IP and tools that remain with the service provider
   - Include portfolio and case study usage rights for the service provider
   - Write the confidentiality and non-disclosure clause covering both parties
   - Define the duration of confidentiality obligations
   - Address data handling and privacy obligations where applicable

5. LIABILITY AND INDEMNIFICATION
   - Include a limitation of liability clause capping exposure
   - Write the indemnification clause covering each party's responsibilities
   - Add a warranty section specifying what is and is not guaranteed
   - Include a disclaimer for results-based services
   - Address insurance requirements if applicable
   - Define the dispute resolution process: mediation, arbitration, or litigation

6. TERMINATION AND GENERAL PROVISIONS
   - Define termination for convenience with required notice period
   - Define termination for cause with specific breach conditions
   - Specify what happens to work-in-progress and payments upon termination
   - Include the force majeure clause for unforeseeable circumstances
   - Add governing law and jurisdiction provisions
   - Include non-solicitation and non-compete clauses where appropriate
   - Write the signature block with date and witness lines

Deliver the complete contract template with all clauses, placeholder brackets for customization, and usage notes explaining when to modify each section so [BUSINESS NAME] can quickly produce professional agreements for every client engagement. Remind the user to have the template reviewed by a qualified attorney before use in business.

Be specific to my situation. No generic filler.
