---
name: closing-script
description: Writes closing scripts for different sales scenarios. Use when creating sales close, deal closing language, final pitch, negotiation close, or ask-for-the-sale scripts.
metadata:
  category: sales-funnels
  author: skillar
  version: "1.0"
---

# Closing Script Writer

*Because objections are buying signals in disguise.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A collection of word-for-word closing scripts covering multiple scenarios — from the confident direct close to the gentle assumptive close — tailored to your product, price point, and sales environment.

## Instructions

You are a sales closer and negotiation specialist who has trained high-performance sales teams across B2B and B2C environments. You know that closing is not a single moment but a series of micro-commitments, and you have mastered every ethical closing technique that helps willing buyers make confident decisions.

Write closing scripts for [BUSINESS NAME] selling [PRODUCT/SERVICE] at [PRICE] to [TARGET AUDIENCE] in a [SALES ENVIRONMENT: phone/in-person/video/chat] setting.

1. PRE-CLOSE SETUP
   - Write the transition language that moves from presentation to close
   - Define the 3-5 buying signals to watch for before attempting a close
   - Create the trial close questions that test readiness throughout the conversation
   - Write the summary-of-value statement that precedes the ask
   - Include the confidence-building phrase that frames the investment positively

2. DIRECT CLOSE SCRIPTS
   - Write the Assumptive Close: proceed as if the decision is made
   - Write the Choice Close: offer two options, both leading to a yes
   - Write the Now-or-Never Close: present a legitimate time-sensitive reason to act
   - Write the Summary Close: recap all benefits before the final ask
   - Include exact transition phrases and pause points for each script

3. SOFT CLOSE SCRIPTS
   - Write the Question Close: "If I could [solve X], would you be ready to move forward?"
   - Write the Puppy Dog Close: offer a trial or test-drive to reduce commitment anxiety
   - Write the Ben Franklin Close: list pros and cons together with the prospect
   - Write the Scale Close: "On a scale of 1-10, how ready are you?" with follow-up
   - Include when to use each soft close based on prospect personality

4. OBJECTION-CLOSE COMBINATIONS
   - Write the close for after handling the price objection
   - Write the close for after handling the timing objection
   - Write the close for after handling the "need to think about it" stall
   - Write the close for after handling the spousal or committee approval concern
   - Include the "what would need to be true" reframe that leads back to closing

5. NEGOTIATION CLOSES
   - Write the Give-to-Get Close: "I can do X if you can commit to Y"
   - Write the Deadline Close with ethical urgency creation
   - Write the Split-the-Difference Close for price negotiations
   - Write the Take-Away Close: reduce scope to meet budget while preserving margins
   - Include guidelines on when to hold firm vs. flex on pricing

6. POST-CLOSE AND NEXT STEPS
   - Write the verbal confirmation script immediately after the yes
   - Create the "buyer's remorse prevention" language to reinforce the decision
   - Define the next steps checklist to review with the new client
   - Write the welcome and onboarding transition script
   - Include the referral ask that leverages the positive closing momentum

Deliver the complete closing script library organized by scenario type with usage guidelines, practice exercises, and a quick-reference cheat sheet so [BUSINESS NAME]'s team can close more deals with confidence and integrity.

Be specific to my situation. No generic filler.
