---
name: welcome-sequence
description: Generates a 5-email welcome sequence for new subscribers. Use when onboarding new email subscribers, setting up welcome drip, or creating a nurture intro series with calls-to-action.
metadata:
  category: email-automation
  author: skillar
  version: "1.0"
---

# Welcome Email Sequence Generator

*Because first impressions in email set the tone for every email after.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete 5-email welcome sequence with subject lines, preview text, full body copy, CTAs, and recommended send timing — designed to nurture new subscribers from first impression to first conversion.

## Instructions

You are a email marketing strategist who specializes in subscriber onboarding and welcome sequences that build trust, deliver value, and guide new subscribers toward meaningful engagement. You craft emails that feel personal, not corporate.

Create a 5-email welcome sequence for [BRAND/COMPANY NAME] in the [INDUSTRY/NICHE] space. The target audience is [TARGET AUDIENCE DESCRIPTION]. The primary goal of this sequence is to guide subscribers toward [PRIMARY CONVERSION GOAL]. The brand voice is [BRAND VOICE/TONE — e.g., warm and conversational, bold and edgy, professional yet approachable].

### 1. SEQUENCE ARCHITECTURE
- Map out the 5-email journey with recommended send intervals (Day 0, Day 1, Day 3, Day 5, Day 7)
- Define the strategic purpose of each email in the sequence
- Ensure a logical emotional arc from welcome warmth to conversion confidence
- Identify the key trust-building milestones across the sequence
- Note the escalation of commitment asked from the subscriber at each step

### 2. EMAIL 1 — THE WARM WELCOME
- Write a subject line that feels personal and sets expectations (under 50 characters)
- Open with genuine gratitude and a human connection point
- Deliver on any opt-in promise or lead magnet immediately
- Introduce the brand story in 2-3 sentences that highlight the subscriber's benefit
- Include a low-friction CTA (reply, follow, read a post) to build engagement habits
- Add preview text that complements the subject line

### 3. EMAIL 2 — VALUE DELIVERY
- Provide the single most useful piece of content or insight for [TARGET AUDIENCE DESCRIPTION]
- Position the brand as the go-to authority with a quick win or actionable tip
- Use storytelling or a case study snippet to make the value tangible
- Include a CTA that deepens engagement (download, watch, explore)
- Keep the tone helpful and generous, not salesy

### 4. EMAIL 3 — SOCIAL PROOF AND TRUST
- Share a compelling customer story, testimonial, or transformation result
- Address the top 1-2 objections or hesitations [TARGET AUDIENCE DESCRIPTION] typically has
- Use specific numbers, outcomes, or before/after contrasts
- Introduce the product or service naturally through the customer story
- Include a CTA to explore offerings or read more success stories

### 5. EMAIL 4 — THE SOFT PITCH
- Transition from value to offer with a bridge that connects their problem to your solution
- Present the core offer with 3-5 benefit-driven bullet points
- Include a risk-reversal element (guarantee, free trial, no commitment)
- Add a personal note or founder message to humanize the pitch
- Use a clear, action-oriented CTA button with supporting text
- Mention scarcity or urgency only if authentic

### 6. EMAIL 5 — THE CONVERSION CLOSE
- Open with a recap of the value delivered across the sequence
- Restate the offer with emphasis on transformation, not features
- Include a final testimonial or proof point
- Create genuine urgency with a deadline, bonus, or limited availability
- Provide two CTA options: primary conversion and a softer alternative
- Close with a forward-looking statement about the subscriber relationship

### 7. TECHNICAL SPECIFICATIONS
- Write each email with subject line, preview text, body copy, and CTA button text
- Keep emails between 150-300 words each
- Format for skimmability with short paragraphs, bold key phrases, and whitespace
- Include merge tag placeholders like [FIRST_NAME] where personalization fits
- Note any segmentation triggers or conditional logic opportunities

Deliver the complete 5-email sequence ready to load into any email marketing platform, with strategic notes on timing, segmentation opportunities, and A/B test suggestions for subject lines.

Be specific to my situation. No generic filler.
