---
name: upsell-email
description: Writes a post-purchase upsell email that feels helpful not pushy. Use when creating upsell flows, cross-sell campaigns, or post-purchase email automation sequences.
metadata:
  category: email-automation
  author: skillar
  version: "1.0"
---

# Post-Purchase Upsell Email

*Because the easiest person to sell to is someone who already bought from you.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A carefully crafted post-purchase upsell email that recommends a complementary product or upgrade in a way that feels like helpful guidance — increasing average customer value without eroding trust or satisfaction.

## Instructions

You are a customer lifecycle email strategist who specializes in post-purchase revenue optimization. You believe the best upsell does not feel like a sales pitch — it feels like a friend saying "you should also try this." You write emails that deepen the customer relationship while increasing lifetime value.

Write a post-purchase upsell email for [BRAND/COMPANY NAME]. The customer just purchased [ORIGINAL PRODUCT/SERVICE]. The upsell offer is [UPSELL PRODUCT/SERVICE] at [UPSELL PRICE/OFFER]. The connection between the two products is [HOW UPSELL COMPLEMENTS ORIGINAL PURCHASE]. The brand voice is [BRAND VOICE/TONE]. The target customer profile is [CUSTOMER DESCRIPTION].

### 1. TIMING AND CONTEXT STRATEGY
- Recommend the optimal send time after purchase (e.g., immediately, 2 days, after delivery)
- Justify the timing based on the customer's mindset at that stage
- Define the trigger event: purchase confirmation, delivery notification, or first use
- Consider the customer's emotional state: excitement, anticipation, or satisfaction
- Ensure the email does not conflict with transactional emails (shipping, receipts)

### 2. SUBJECT LINE AND OPENER
- Write 3 subject line options that feel like helpful tips, not sales pitches
- Avoid words like "deal," "offer," or "buy" in the subject line
- Open by celebrating their recent purchase and reinforcing their decision
- Use [FIRST_NAME] and [ORIGINAL PRODUCT/SERVICE] merge tags for personalization
- Transition naturally from congratulations to recommendation
- Set a tone that mirrors a trusted advisor, not a salesperson

### 3. THE RECOMMENDATION BRIDGE
- Connect the original purchase to the upsell with a logical, benefit-driven bridge
- Explain how [UPSELL PRODUCT/SERVICE] enhances, completes, or accelerates results from [ORIGINAL PRODUCT/SERVICE]
- Use a "customers who bought X also loved Y" framework if appropriate
- Share a specific use case or scenario that makes the pairing feel obvious
- Keep the recommendation conversational — "You might also love..." not "Buy this now"

### 4. VALUE PRESENTATION
- Present [UPSELL PRODUCT/SERVICE] with 3-4 benefit bullets focused on the customer's outcome
- Include one specific result or testimonial from a customer who purchased both products
- Show the combined value of owning both rather than just the upsell in isolation
- If offering a discount or bundle price, frame it as an exclusive "thank you" for recent buyers
- Include product image placeholder [UPSELL_PRODUCT_IMAGE] for visual appeal
- Keep the product description concise — they already trust your brand

### 5. THE SOFT CTA AND EXIT RAMP
- Use a CTA that feels like exploration, not commitment: "See how it works" or "Learn more"
- Include the price transparently — no bait-and-switch feeling
- Offer a time-limited sweetener if applicable: [UPSELL INCENTIVE — e.g., 15% off, free add-on]
- Provide an easy opt-out from future product recommendations without unsubscribing entirely
- Add a secondary CTA for customer support or questions about their original purchase
- Close with genuine well-wishes for their experience with [ORIGINAL PRODUCT/SERVICE]

### 6. PERSONALIZATION AND SEGMENTATION
- Include dynamic content placeholders for order details and product-specific recommendations
- Suggest segmentation rules: first-time vs. repeat buyers, order value tiers, product category
- Recommend suppression for customers who already own the upsell product
- Note any behavioral triggers that indicate higher upsell readiness (quick reorder, positive review)
- Provide a fallback version for cases where dynamic product data is unavailable

Deliver the complete upsell email with subject lines, preview text, full body copy, CTA, and implementation notes including recommended send timing, segmentation rules, and performance benchmarks to track.

Be specific to my situation. No generic filler.
