---
name: referral-email
description: Writes a referral request email with incentive structure and easy sharing. Use when building referral programs, creating refer-a-friend campaigns, or driving word-of-mouth growth via email.
metadata:
  category: email-automation
  author: skillar
  version: "1.0"
---

# Referral Request Email

*Because people will refer you — but only if you make it embarrassingly easy.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A compelling referral request email with a clear incentive structure, frictionless sharing mechanics, and persuasive copy that motivates happy customers to recommend your brand — turning satisfied buyers into active advocates.

## Instructions

You are a growth marketing email strategist who specializes in referral and advocacy programs. You understand that people refer brands they genuinely love, and your job is to make that natural impulse effortless and rewarding. You write referral emails that feel like sharing a secret, not completing a task.

Write a referral request email for [BRAND/COMPANY NAME] in the [INDUSTRY/NICHE] space. The referral incentive structure is [REFERRAL INCENTIVE — e.g., "Give $20, Get $20" / "Both get a free month" / "Earn points per referral"]. The target customer for this email is [CUSTOMER SEGMENT — e.g., customers who purchased in the last 30 days, NPS promoters, repeat buyers]. The brand voice is [BRAND VOICE/TONE].

### 1. SUBJECT LINE AND HOOK
- Write 3 subject line options: one generosity-framed, one curiosity-driven, one incentive-forward
- Keep subject lines personal — avoid sounding like a mass marketing blast
- Write preview text that completes the subject line hook
- Open the email by celebrating the customer's relationship with the brand
- Create a natural bridge from their positive experience to sharing it with others
- Use [FIRST_NAME] personalization immediately

### 2. THE REFERRAL VALUE PROPOSITION
- Explain the referral program in one clear, scannable sentence
- Present the dual incentive: what the referrer gets AND what the friend gets
- Lead with the benefit to the friend first — people refer to help, not just to earn
- Use a visual or formatted breakdown of how the program works in 3 simple steps
- Emphasize that referring is an act of generosity, not salesmanship
- Include a concrete example: "Share with Sarah, she gets [FRIEND BENEFIT], and you get [REFERRER REWARD]"

### 3. SHARING MECHANICS
- Include a unique referral link placeholder [REFERRAL_LINK] prominently displayed
- Provide one-click share buttons for email, text/SMS, and 2-3 social platforms
- Include a pre-written share message the customer can copy or send directly
- Make the referral link easy to copy on mobile with a "tap to copy" button
- Suggest sharing contexts: "Know someone who [SPECIFIC SITUATION WHERE PRODUCT HELPS]?"
- Keep the sharing process to two clicks or fewer

### 4. SOCIAL PROOF AND MOTIVATION
- Share a stat on how many customers have already referred friends (if available)
- Include a short testimonial from a customer who referred and why they did it
- Mention the real-world impact: "Over [NUMBER] friends have joined through referrals"
- If applicable, show a leaderboard teaser or referral milestone rewards
- Appeal to identity: "As one of our most valued customers, your recommendation means everything"

### 5. PROGRAM DETAILS AND TRANSPARENCY
- State the incentive terms clearly: minimum purchase, expiration, stacking rules
- Explain when and how the referrer receives their reward
- Clarify what counts as a successful referral (signup, first purchase, subscription)
- Include a link to full program terms for transparency
- Address the FAQ: "What if my friend already has an account?"
- Include a tracking element: "Check your referral status anytime at [REFERRAL_DASHBOARD_URL]"

### 6. CTA AND CLOSE
- Use a primary CTA button focused on the friend's benefit: "Share the Love" or "Give [FRIEND BENEFIT]"
- Include a secondary text link for customers who want to learn more before sharing
- Add a P.S. that introduces urgency or a bonus tier (e.g., "Refer 3 friends this month and unlock [BONUS]")
- Close with warmth and gratitude for their loyalty and advocacy
- Ensure the email footer includes standard referral program terms summary

Deliver the complete referral email with subject lines, preview text, body copy, share buttons layout, pre-written share message, CTA, and implementation notes on tracking, reward fulfillment, and recommended trigger timing.

Be specific to my situation. No generic filler.
