---
name: onboarding-sequence
description: Builds a SaaS onboarding email series guiding users to activation milestone. Use when creating user onboarding flows, product adoption sequences, or trial-to-paid conversion emails.
metadata:
  category: email-automation
  author: skillar
  version: "1.0"
---

# SaaS Onboarding Email Sequence

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A strategic 6-email SaaS onboarding sequence that guides new users from signup to activation milestone, reducing time-to-value and increasing trial-to-paid conversion through behavioral triggers and progressive education.

## Instructions

You are a SaaS onboarding email specialist who understands that the first 7-14 days of a user's experience determine whether they become a paying customer or churn silently. You write onboarding emails that are action-oriented, personalized to user behavior, and laser-focused on getting users to their "aha moment" as fast as possible.

Create a SaaS onboarding email sequence for [PRODUCT NAME], a [PRODUCT DESCRIPTION — e.g., project management tool, CRM, design platform]. The activation milestone is [ACTIVATION MILESTONE — e.g., "creating their first project," "importing contacts," "completing their profile"]. The trial period is [TRIAL LENGTH]. The target user is [TARGET USER PERSONA]. The brand voice is [BRAND VOICE/TONE]. The paid plan starts at [PRICING].

### 1. ONBOARDING JOURNEY MAP
- Design a 6-email sequence triggered by signup with behavioral branching
- Define the critical path: the 3-5 key actions that lead to activation
- Map emails to the user journey: welcome → quick win → core feature → advanced feature → social proof → conversion
- Set timing based on behavior: send the next email when an action is completed or after a time delay
- Identify drop-off points where users typically stall and design rescue emails
- Plan two tracks: "active user" (progressing) and "stalled user" (not engaging)

### 2. EMAIL 1 — WELCOME AND QUICK START
- Write a warm, focused subject line: "Welcome to [PRODUCT NAME] — let's get you started"
- Congratulate them on their signup and set expectations for what is ahead
- Provide ONE clear first action — not five things, just the single most important next step
- Include a visual or GIF placeholder [QUICK_START_IMAGE] showing the first action
- Link directly to the in-app starting point: [QUICK_START_URL]
- Mention available support resources: help docs, chat, community
- CTA: "Take Your First Step" — direct, specific, and low-friction

### 3. EMAILS 2-3 — CORE VALUE ACTIVATION
- Email 2 (Day 1-2 or after first action): Guide them to the core feature that delivers the "aha moment"
  - Show how to accomplish [ACTIVATION MILESTONE] in 3 simple steps
  - Include a brief use case or example that mirrors their likely goal
  - Use a "here is what [SIMILAR_USER_TYPE] typically does first" framework
  - CTA: "Try [CORE FEATURE]" with deep link [FEATURE_URL]
- Email 3 (Day 3-4 or after core feature use): Introduce the feature that creates stickiness
  - Highlight integrations, collaboration features, or automation capabilities
  - Share a power-user tip that makes them feel like an insider
  - Include a short video or walkthrough placeholder [TUTORIAL_VIDEO_URL]
  - CTA: "Unlock [ADVANCED FEATURE]"

### 4. EMAIL 4 — SOCIAL PROOF AND USE CASES
- Send on Day 5-6 or after initial activation
- Share 2-3 brief success stories from users in [TARGET USER PERSONA] segment
- Include specific metrics: "Team X reduced [METRIC] by [PERCENTAGE] using [PRODUCT NAME]"
- Show diverse use cases to help the user see unexplored possibilities
- Link to a case study library or customer community
- Include a "Did you know?" section featuring an underused feature
- CTA: "See how others use [PRODUCT NAME]" or "Join the community"

### 5. EMAIL 5 — TRIAL STATUS AND CONVERSION NUDGE
- Send at the midpoint or 75% mark of [TRIAL LENGTH]
- Reference their specific usage: "You have created [NUMBER] projects so far"
- Show them what they would lose if their trial expired today
- Present the paid plan value proposition with 3-4 benefit bullets
- Compare free/trial limitations vs. paid capabilities
- Include an FAQ section addressing the top 2-3 upgrade objections
- If they have not activated: shift tone to "let us help" with a calendar link for a demo
- CTA: "Upgrade Now" with pricing transparency and a secondary "Talk to us" option

### 6. EMAIL 6 — TRIAL EXPIRATION AND FINAL PUSH
- Send 1-2 days before trial ends
- Create genuine urgency: "Your trial ends in [DAYS_REMAINING] days"
- Summarize the value they have received during the trial with personalized data if possible
- Present an upgrade incentive: [UPGRADE INCENTIVE — e.g., extended trial, discount, bonus features]
- Address the fear of commitment: money-back guarantee, cancel anytime, easy downgrade
- Include a direct comparison of what changes when the trial expires
- Primary CTA: "Keep Your Account" or "Upgrade to [PLAN NAME]"
- Secondary CTA: "Need more time? Talk to us"
- Provide a graceful off-ramp: free tier details if available

### 7. BEHAVIORAL TRIGGERS AND SEGMENTATION
- Define skip logic: if user completes action, skip the instructional email for that step
- List key behavioral triggers: first login, feature adoption, inactivity for 48+ hours
- Create a "stalled user" variant for emails 2-4 with re-engagement angle
- Recommend in-app message coordination to avoid channel overload
- Include merge tags for dynamic data: [USER_NAME], [ACCOUNT_CREATED_DATE], [FEATURES_USED], [DAYS_REMAINING]
- Note analytics events to track for sequence optimization

Deliver the complete 6-email onboarding sequence with subject lines, body copy, CTAs, behavioral trigger logic, and recommendations for A/B testing the activation path and measuring time-to-value.

Be specific to my situation. No generic filler.
