---
name: nurture-sequence
description: Builds a 7-email nurture sequence that develops trust and guides subscribers to purchase. Use when creating drip campaigns, lead nurturing flows, or educational email series that convert.
metadata:
  category: email-automation
  author: skillar
  version: "1.0"
---

# Email Nurture Sequence Builder

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A strategic 7-email nurture sequence with full copy, subject lines, and send schedule that progressively builds trust, educates your audience, and naturally guides them from awareness to purchase decision.

## Instructions

You are a conversion-focused email copywriter who specializes in long-form nurture sequences. You understand that trust is built through consistent value, not constant pitching. Your sequences educate and inspire while quietly positioning the offer as the natural next step.

Create a 7-email nurture sequence for [BRAND/COMPANY NAME] targeting [TARGET AUDIENCE DESCRIPTION] who are interested in [TOPIC/PROBLEM AREA]. The end goal is to drive purchases of [PRODUCT/SERVICE/OFFER]. The brand voice is [BRAND VOICE/TONE]. The lead magnet or opt-in that started this sequence was [LEAD MAGNET DESCRIPTION].

### 1. SEQUENCE BLUEPRINT
- Map the 7-email arc: introduce → educate → inspire → relate → differentiate → present → convert
- Define send cadence (recommended: every 2-3 days over 14-21 days)
- Assign each email a single strategic objective and emotional target
- Plan the value-to-pitch ratio (aim for 80/20 across the full sequence)
- Identify content themes that align with [TARGET AUDIENCE DESCRIPTION] pain points and desires

### 2. EMAILS 1-2 — FOUNDATION AND AUTHORITY
- Email 1: Deliver on the lead magnet promise and set expectations for what is coming
  - Open with acknowledgment of their specific challenge
  - Provide an unexpected insight or contrarian take on [TOPIC/PROBLEM AREA]
  - Close with a teaser for the next email to build anticipation
- Email 2: Share the #1 mistake or misconception in [TOPIC/PROBLEM AREA]
  - Use data, research, or personal experience to support the claim
  - Offer a quick-win framework they can apply immediately
  - Position your approach as distinctly different from conventional advice
  - Include a CTA to a valuable resource (blog post, video, tool)

### 3. EMAILS 3-4 — STORYTELLING AND SOCIAL PROOF
- Email 3: Tell a transformation story (customer case study or personal journey)
  - Use the before/after/bridge storytelling framework
  - Include specific, measurable results and outcomes
  - Make the reader see themselves in the story
  - End with a reflection question that prompts self-assessment
- Email 4: Share multiple proof points and community validation
  - Feature 3-4 short testimonials or success snapshots
  - Highlight diverse use cases within [TARGET AUDIENCE DESCRIPTION]
  - Introduce the concept behind your methodology or product naturally
  - Include a CTA to join a community, watch a training, or explore further

### 4. EMAILS 5-6 — EDUCATION AND DIFFERENTIATION
- Email 5: Deliver a high-value teaching email (the "best free content" email)
  - Provide a complete mini-framework, checklist, or step-by-step process
  - Make it genuinely useful as standalone content
  - Subtly show how [PRODUCT/SERVICE/OFFER] accelerates or enhances this process
  - Include a soft mention of your solution without making it the focus
- Email 6: Address objections and differentiate from alternatives
  - Tackle the top 3 reasons people hesitate to invest in [PRODUCT/SERVICE/OFFER]
  - Compare approaches (DIY vs. guided, free vs. paid, your way vs. others) fairly
  - Use a "who this is for / who this is not for" framework to qualify
  - Build desire by painting a vivid picture of the post-purchase outcome

### 5. EMAIL 7 — THE CONVERSION EMAIL
- Open with a summary of the journey and value delivered across 6 emails
- Present [PRODUCT/SERVICE/OFFER] as the logical next step
- Include 5-7 benefit-driven bullet points focused on outcomes
- Add a compelling risk-reversal element (guarantee, trial, payment plan)
- Feature one final powerful testimonial
- Create urgency with a genuine deadline, bonus, or enrollment window
- Use a primary CTA and a secondary "have questions?" option
- Close with a personal sign-off that reinforces the relationship

### 6. FORMATTING AND TECHNICAL SPECS
- Write each email with subject line, preview text, full body, and CTA
- Keep emails between 200-400 words (teaching email can extend to 500)
- Use [FIRST_NAME] personalization throughout
- Format for mobile readability: short paragraphs, bold highlights, clear hierarchy
- Include transition hooks between emails to maintain narrative continuity
- Note segmentation triggers (link clicks, opens) for advanced automation

Deliver the complete 7-email nurture sequence as a ready-to-implement campaign with strategic notes on timing, segmentation branch points, and recommendations for ongoing optimization.

Be specific to my situation. No generic filler.
