---
name: newsletter-template
description: Generates a reusable newsletter template with sections and formatting. Use when building recurring newsletters, designing email digest layouts, or creating branded newsletter frameworks.
metadata:
  category: email-automation
  author: skillar
  version: "1.0"
---

# Reusable Newsletter Email Template

*Because inconsistent newsletters train people to ignore you.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete, reusable newsletter template with defined sections, formatting guidelines, and placeholder copy that you can fill in each week or month — maintaining consistency while saving hours of writing time.

## Instructions

You are a newsletter strategist and email designer who has built high-performing recurring newsletters for brands and creators. You know that the best newsletters have a consistent, recognizable structure that readers come to expect and enjoy. You design templates that are easy to produce and a pleasure to read.

Design a reusable newsletter template for [BRAND/COMPANY NAME] in the [INDUSTRY/NICHE] space. The newsletter is sent [FREQUENCY — e.g., weekly, biweekly, monthly]. The target audience is [TARGET AUDIENCE DESCRIPTION]. The newsletter's core promise is [NEWSLETTER VALUE PROPOSITION — e.g., "The best marketing insights in 5 minutes"]. The brand voice is [BRAND VOICE/TONE].

### 1. TEMPLATE STRUCTURE AND SECTIONS
- Design 4-6 recurring sections that align with [NEWSLETTER VALUE PROPOSITION]
- Assign each section a catchy, branded name (e.g., "This Week's Top Pick," "Quick Wins," "Tool of the Week")
- Define the purpose and word count for each section (keep total under 800 words)
- Arrange sections in order of engagement priority — lead with the strongest content
- Include one rotating or optional section for variety and freshness
- Create visual dividers or transition phrases between sections

### 2. HEADER AND SUBJECT LINE FRAMEWORK
- Design a subject line formula that can be reused with swappable elements (e.g., "[Topic]: [Benefit] + [Curiosity hook]")
- Provide 5 example subject lines using the formula
- Write a standard preview text template with a customizable element
- Include a branded header greeting that sets the tone (e.g., "Happy [DAY], [FIRST_NAME] — here is what matters this week")
- Add a one-line "issue summary" or "in this issue" preview below the greeting

### 3. PRIMARY CONTENT SECTION
- Design the main feature section: the anchor piece each issue revolves around
- Provide a fill-in template: headline, 3-4 sentence summary, key takeaway, CTA link
- Include formatting guidelines: bold the main insight, italicize quotes, bullet key points
- Suggest content types that rotate: deep dive, interview highlight, trend analysis, how-to
- Write placeholder copy showing exactly how a completed section looks
- Include an image or visual placeholder [FEATURED_IMAGE]

### 4. SECONDARY CONTENT SECTIONS
- Design 2-3 shorter sections with fill-in templates for each
- Section ideas: curated links (3-5 items with one-line descriptions), quick tip or hack, stat of the week, community spotlight, question of the week
- Provide formatting for each: title, 1-2 sentence description, link or CTA
- Keep each secondary section to 50-100 words
- Include bullet or numbered list formatting for scanability

### 5. CTA AND ENGAGEMENT SECTION
- Design a recurring CTA section that promotes [PRIMARY BUSINESS GOAL — e.g., product, course, service, event]
- Keep the CTA section to 2-3 lines so it feels integrated, not intrusive
- Rotate CTA copy monthly — provide 3 variations
- Include a "share this newsletter" section with forwarding and social share links
- Add a "reply and tell us" prompt to encourage direct engagement
- Include a referral program callout if applicable

### 6. FOOTER AND HOUSEKEEPING
- Design a branded footer with consistent elements: about blurb, social links, contact info
- Include an unsubscribe link and email preference center link
- Add a brief "Why you are receiving this" line for trust and compliance
- Include a "Was this forwarded to you? Subscribe here" link with [SUBSCRIBE_URL]
- Suggest a standard sign-off phrase that becomes part of the brand identity
- Note any legal requirements: physical address, CAN-SPAM compliance

Deliver the complete newsletter template with all sections filled with example copy, formatting guidelines, a subject line formula with examples, and a production checklist the sender can follow each issue to streamline creation.

Be specific to my situation. No generic filler.
