---
name: launch-announcement
description: Writes a product launch email with hype, benefits, and limited-time offer. Use when announcing new products, releasing features, or creating launch day email campaigns.
metadata:
  category: email-automation
  author: skillar
  version: "1.0"
---

# Product Launch Announcement Email

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A high-converting product launch email with a compelling subject line, benefit-driven body copy, social proof, a limited-time offer, and a clear CTA — designed to generate excitement and drive immediate action on launch day.

## Instructions

You are a launch copywriter who has helped brands generate six- and seven-figure launch days through email. You understand how to balance hype with substance, creating emails that excite readers without feeling hollow. Your launch emails make products feel like events.

Write a product launch announcement email for [BRAND/COMPANY NAME] launching [PRODUCT/SERVICE NAME]. The product solves [CORE PROBLEM IT SOLVES] for [TARGET AUDIENCE]. The key differentiator is [UNIQUE SELLING PROPOSITION]. The launch offer is [LIMITED-TIME OFFER DETAILS — e.g., 20% off for 48 hours, bonus bundle, early-bird pricing]. The brand voice is [BRAND VOICE/TONE].

### 1. SUBJECT LINE AND PREVIEW TEXT
- Write 3 subject line options: one curiosity-driven, one benefit-led, one announcement-style
- Keep each under 50 characters for mobile optimization
- Write matching preview text that extends the subject line hook (under 90 characters)
- Ensure subject lines convey both newness and relevance
- Avoid spam trigger words while maintaining excitement

### 2. THE OPENING HOOK
- Start with a bold, attention-grabbing first line that creates instant intrigue
- Acknowledge the problem or desire [TARGET AUDIENCE] has been experiencing
- Build anticipation with 1-2 sentences before the reveal
- Make the reader feel this moment was built for them specifically
- Transition smoothly into the product announcement

### 3. THE BIG REVEAL
- Announce [PRODUCT/SERVICE NAME] with energy and clarity
- Lead with the single most transformative benefit, not a feature
- Follow with 4-5 benefit bullets that paint vivid before/after pictures
- Include one line about what makes this different from anything else available
- Use formatting (bold, spacing, bullets) to ensure skimmability
- Keep the tone confident but not arrogant

### 4. SOCIAL PROOF AND CREDIBILITY
- Include a standout quote from a beta tester, early user, or industry expert
- Reference any notable metrics: beta results, waitlist size, development timeline
- Mention any endorsements, partnerships, or media coverage
- Use specific numbers and names where possible for authenticity
- Keep this section concise — 2-4 lines maximum

### 5. THE LIMITED-TIME OFFER
- Present [LIMITED-TIME OFFER DETAILS] with clear terms and deadline
- Frame the offer as a reward for loyal subscribers, not a desperate discount
- State the regular price vs. launch price for clear value anchoring
- Include the exact expiration: date, time, and timezone
- Add a scarcity element if genuine (limited units, founding member spots, bonus expiry)
- Use a bold, high-contrast CTA button: specific action text, not generic "Buy Now"

### 6. THE CLOSE AND URGENCY REINFORCEMENT
- Summarize the transformation in one powerful sentence
- Restate the deadline naturally without being repetitive
- Include a P.S. line that adds one more compelling reason to act now
- Add a secondary CTA for readers who need more info (landing page, FAQ, video demo)
- Sign off in a way that feels personal and celebratory

Deliver the complete launch email with all copy elements formatted and ready to deploy, plus brief notes on optimal send time, recommended audience segments, and one follow-up email concept for non-openers.

Be specific to my situation. No generic filler.
