---
name: feedback-request-email
description: Creates a customer feedback request email with high response rate tactics. Use when soliciting reviews, running NPS surveys, collecting testimonials, or gathering post-purchase feedback.
metadata:
  category: email-automation
  author: skillar
  version: "1.0"
---

# Customer Feedback Request Email

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A high-response-rate feedback request email that makes customers feel valued and heard, using proven psychological triggers to maximize completion rates while gathering actionable insights and potential testimonials.

## Instructions

You are a customer experience email specialist who understands that feedback emails are both a data collection tool and a relationship-building moment. You write requests that feel like genuine conversations, not chores — and you consistently achieve response rates well above industry averages.

Write a feedback request email for [BRAND/COMPANY NAME]. The customer purchased or used [PRODUCT/SERVICE] approximately [TIME SINCE PURCHASE/USE]. The type of feedback sought is [FEEDBACK TYPE — e.g., product review, NPS score, detailed survey, testimonial]. The brand voice is [BRAND VOICE/TONE]. The target customer segment is [CUSTOMER SEGMENT].

### 1. TIMING AND TRIGGER STRATEGY
- Recommend the ideal send time relative to purchase, delivery, or usage milestone
- Explain why this timing maximizes response quality and rate
- Define the trigger event that initiates the email
- Consider whether the customer has had enough time to form a meaningful opinion
- Suggest a suppression window to avoid conflicts with support tickets or complaints

### 2. SUBJECT LINE AND OPENING
- Write 3 subject line options: one personal question, one that emphasizes impact, one curiosity-driven
- Keep subject lines under 45 characters and avoid looking like marketing
- Open with a warm, personal acknowledgment of the customer relationship
- Reference [PRODUCT/SERVICE] and [FIRST_NAME] for relevance and personalization
- State the purpose honestly within the first two sentences
- Emphasize that their specific opinion matters — avoid generic language

### 3. THE ASK — MAKING IT EASY AND MEANINGFUL
- Frame the feedback request around impact: "Your feedback helps us..." with a specific outcome
- Specify exactly how long the feedback will take (be honest: "2 minutes" or "one quick question")
- If using a survey, include the first question directly in the email body to reduce friction
- For NPS: embed the 0-10 scale as clickable links or buttons within the email
- For reviews: provide a direct link to the review platform [REVIEW_PLATFORM_URL]
- Make the action feel small: "Just one question" or "Three quick clicks"

### 4. INCENTIVE AND MOTIVATION
- Include a thank-you incentive if applicable: [INCENTIVE — e.g., 10% off next order, entry into giveaway, free resource]
- If no tangible incentive, use intrinsic motivation: community impact, helping others decide, shaping future products
- Share how previous customer feedback led to a specific improvement or change
- Appeal to their identity as a valued member of the [BRAND/COMPANY NAME] community
- Frame the incentive as gratitude, not payment for their time

### 5. SOCIAL PROOF AND RESPONSE FACILITATION
- Mention how many other customers have already shared feedback (if impressive)
- Include a sample response or testimonial to model the type of feedback you want
- Provide multiple response channels if possible: email reply, survey link, review site
- For longer surveys, include a progress indicator or section preview
- Add a "reply to this email" option for customers who prefer freeform responses
- Include a CTA button that is prominent, friendly, and action-specific

### 6. THE CLOSE AND FOLLOW-UP PLAN
- Express genuine gratitude regardless of whether they respond
- Reassure them their feedback is read by real humans, not just algorithms
- Include a P.S. with a direct line to customer support for any unresolved issues
- Note the follow-up plan: a gentle reminder email 3-5 days later for non-respondents
- Suggest a thank-you email for respondents acknowledging their contribution
- Close with a personal sign-off, not a corporate signature

Deliver the complete feedback request email with subject lines, preview text, full body copy, embedded first question or rating scale, CTA, and notes on follow-up sequences, response tracking, and how to turn positive feedback into usable testimonials.

Be specific to my situation. No generic filler.
