---
name: churn-prevention-email
description: Creates a churn prevention email triggered by disengagement signals. Use when building retention flows, reducing subscriber churn, or responding to at-risk user behavior with automated emails.
metadata:
  category: email-automation
  author: skillar
  version: "1.0"
---

# Churn Prevention Email

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A strategically crafted churn prevention email triggered by disengagement signals, designed to re-engage at-risk users before they cancel — combining empathy, value reinforcement, and a clear path back to active usage.

## Instructions

You are a retention marketing specialist who prevents churn by intercepting disengagement at the earliest signals. You understand that most users do not churn because of a single bad experience — they drift away gradually. Your emails acknowledge the drift without blame and offer genuine paths back to value.

Write a churn prevention email for [PRODUCT/SERVICE NAME] by [BRAND/COMPANY NAME]. The disengagement trigger is [TRIGGER — e.g., "no login for 14 days," "usage dropped 50%," "downgraded plan," "removed team members"]. The target user is [USER PERSONA]. The core value proposition of [PRODUCT/SERVICE NAME] is [CORE VALUE PROPOSITION]. The brand voice is [BRAND VOICE/TONE]. The subscription price is [PRICE/PLAN DETAILS].

### 1. TRIGGER DEFINITION AND TIMING
- Define the specific behavioral signal that triggers this email
- Recommend the ideal delay between trigger event and email send (e.g., 24-48 hours)
- Identify false positive scenarios to exclude from the trigger (vacation, seasonal patterns)
- Suggest complementary triggers that indicate escalating churn risk
- Map this email within the broader retention sequence: what comes before and after
- Note suppression rules for users who are already in support conversations

### 2. SUBJECT LINE AND EMOTIONAL TONE
- Write 3 subject line options: one empathetic, one curiosity-based, one value-reminder
- Avoid guilt-inducing or desperate language — no "We miss you" cliches
- Set the tone as a helpful check-in from someone who genuinely cares about their success
- Open with an acknowledgment that does not assume the worst
- Use [FIRST_NAME] personalization to feel like a one-to-one message
- The opening line should feel like it comes from a real person, not an automated system

### 3. VALUE REINFORCEMENT
- Remind them of the specific value they have received from [PRODUCT/SERVICE NAME]
- Include dynamic usage data if available: "You have [USAGE_METRIC] since joining"
- Highlight features or benefits they may not have explored yet
- Share a quick stat: "Users like you who [SPECIFIC ACTION] see [SPECIFIC RESULT]"
- Connect their original reason for signing up to what is still possible
- Keep this section factual and forward-looking, not nostalgic or pleading

### 4. ADDRESS THE ROOT CAUSE
- Acknowledge the most common reasons users in [USER PERSONA] segment disengage
- Offer targeted solutions for each: "If you are feeling overwhelmed, try our quick-start guide"
- Include a "What's getting in the way?" prompt with 3-4 clickable response options
  - Too busy right now
  - Not sure how to use it effectively
  - Found an alternative
  - Missing a feature I need
  - Other
- Link each response to a tailored follow-up: tutorial, feature request form, or support call
- Frame every option as an opportunity to help, not an interrogation

### 5. THE RE-ENGAGEMENT OFFER
- Present a concrete reason to come back today, not just "log in again"
- Suggest a specific action: "Try [NEW FEATURE] — it takes 2 minutes and [BENEFIT]"
- If applicable, offer a retention incentive: [RETENTION OFFER — e.g., free month, discount, upgraded features trial]
- Include a direct deep-link to the most relevant part of the product [REACTIVATION_URL]
- Provide a one-click option to schedule a call with customer success [CALL_BOOKING_URL]
- Make every re-engagement path feel easy and low-commitment

### 6. THE GRACEFUL EXIT
- Include a clear, respectful option to cancel or downgrade without friction
- Frame it as: "If [PRODUCT/SERVICE NAME] is not the right fit right now, no hard feelings"
- Offer a pause option if available: "Take a break without losing your data"
- Mention what happens to their data and account if they leave
- Provide a feedback mechanism for departing users to share why
- Close with a genuine statement of support regardless of their decision

Deliver the complete churn prevention email with subject lines, preview text, full body copy, interactive response buttons, CTAs, and automation notes including trigger logic, follow-up branching based on response clicks, and recommended metrics to track retention impact.

Be specific to my situation. No generic filler.
