---
name: black-friday-campaign
description: Creates a Black Friday or holiday email campaign with teaser, launch, and last chance emails. Use when planning seasonal sales campaigns, holiday email sequences, or high-urgency promotional series.
metadata:
  category: email-automation
  author: skillar
  version: "1.0"
---

# Black Friday / Holiday Email Campaign

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete 5-email Black Friday or holiday campaign sequence — early access teaser, sale launch, mid-sale reminder, last chance, and extended encore — with subject lines, full copy, and urgency tactics designed to maximize seasonal revenue.

## Instructions

You are a seasonal campaign strategist who has orchestrated high-revenue holiday email campaigns for brands across ecommerce and digital products. You understand the balance between urgency and inbox fatigue, and you craft campaigns that cut through the holiday noise with compelling offers and smart sequencing.

Create a Black Friday / holiday email campaign for [BRAND/COMPANY NAME] selling [PRODUCT/SERVICE CATEGORY]. The primary offer is [SALE DETAILS — e.g., 40% off sitewide, BOGO, bundle deals]. The sale runs from [SALE START DATE] to [SALE END DATE]. The target audience is [TARGET AUDIENCE]. The brand voice is [BRAND VOICE/TONE]. The average order value is [AVERAGE ORDER VALUE].

### 1. CAMPAIGN TIMELINE AND STRATEGY
- Map 5 emails: teaser (3-5 days before), launch (sale day), mid-sale (day 2-3), last chance (final day), encore (day after close)
- Define the strategic role and emotional trigger for each email
- Plan the urgency escalation arc across the campaign
- Identify VIP or early-access segments that get priority messaging
- Set send times optimized for holiday inbox competition
- Note suppression rules for recent purchasers between sends

### 2. EMAIL 1 — THE TEASER
- Write a subject line that builds anticipation without revealing the full offer
- Create intrigue about what is coming without using clickbait
- Hint at the scale of the discount or the exclusivity of the deal
- Include a "mark your calendar" or "set a reminder" CTA
- Offer VIP early access as a reward for engagement: [EARLY_ACCESS_URL]
- Keep it short — 100 words max to leave them wanting more

### 3. EMAIL 2 — SALE LAUNCH
- Write an urgent, exciting subject line that announces the sale is live
- Open with energy: the wait is over, the doors are open
- Present the primary offer clearly with exact discount and terms
- Showcase 3-5 top products or categories with [PRODUCT_IMAGE] placeholders
- Include a bold, unmissable CTA: "Shop the Sale" with direct link [SALE_URL]
- Add the end date and time prominently: countdown urgency from day one
- Include a "best sellers" or "staff picks" section for decision simplification

### 4. EMAIL 3 — MID-SALE SOCIAL PROOF
- Write a subject line referencing real-time momentum: sales stats, items selling fast
- Lead with social proof: "Over [NUMBER] orders in the first 24 hours"
- Highlight specific products that are trending or running low
- Include 1-2 short customer reviews or testimonials about featured products
- Remind readers of the offer terms and deadline
- Add a curated picks section: "If you are not sure where to start..."
- CTA: "Continue Shopping" or "See What is Trending"

### 5. EMAIL 4 — LAST CHANCE
- Write an urgent subject line with explicit time remaining: "12 hours left" or "Ends tonight"
- Open with a direct statement: this is the final reminder
- Restate the offer with emphasis on what they will miss
- List 2-3 popular items that are almost sold out (if genuine)
- Include a countdown timer placeholder [COUNTDOWN_TIMER]
- Use scarcity and loss aversion: "After midnight, prices go back to full"
- CTA: "Last Chance — Shop Now" with high visual prominence
- Keep the email short and punchy — urgency, not information

### 6. EMAIL 5 — THE ENCORE (OPTIONAL EXTENSION)
- Write a subject line that surprises: "We extended it" or "One more chance"
- Explain the extension briefly: overwhelming response, final 24 hours, special request
- Present a slightly different or reduced offer to maintain scarcity credibility
- Frame it as a genuine gesture, not a planned tactic
- Set a hard final deadline with no further extensions
- Include a "gift guide" angle if close to the holiday
- CTA: "Final Final Chance" with clear deadline

### 7. CAMPAIGN-WIDE SPECIFICATIONS
- Write each email with subject line, preview text, body copy, and CTA
- Include mobile-responsive formatting notes for each email
- Provide A/B test subject line variants for the launch and last chance emails
- Note exclusions: items not on sale, minimum purchase requirements
- Include dynamic content suggestions for personalized product recommendations
- Specify compliance elements: sale terms, disclaimers, unsubscribe links

Deliver the complete 5-email campaign sequence with all copy ready for deployment, plus a campaign calendar, segmentation recommendations, and post-campaign analysis framework for measuring performance.

Be specific to my situation. No generic filler.
