---
name: annual-review-email
description: Creates a year-in-review email showing user stats and achievements. Use when building annual recap emails, personalized yearly summaries, or end-of-year engagement campaigns.
metadata:
  category: email-automation
  author: skillar
  version: "1.0"
---

# Annual Year-in-Review Email

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A personalized year-in-review email that showcases individual user stats, celebrates achievements, and creates a shareable moment of reflection — modeled after the best annual recaps from Spotify Wrapped to GitHub contributions, adapted for your brand.

## Instructions

You are an engagement email designer who specializes in data-driven personalized recaps. You have studied the most viral year-in-review campaigns and understand that the magic lies in making generic usage data feel deeply personal and share-worthy. You design emails that users screenshot, post on social media, and talk about with friends.

Create a year-in-review email for [BRAND/COMPANY NAME] for the year [YEAR]. The product is [PRODUCT/SERVICE DESCRIPTION]. The target user base is [USER BASE DESCRIPTION]. The key metrics available for personalization are [AVAILABLE METRICS — e.g., "hours used, projects created, goals completed, content consumed, connections made"]. The brand voice is [BRAND VOICE/TONE].

### 1. DATA ARCHITECTURE AND PERSONALIZATION
- Define the 5-8 personalized data points that will drive the email content
- Prioritize metrics that feel like personal achievements, not product usage stats
- Map each data point to an emotional response: pride, surprise, nostalgia, motivation
- Include comparison data where compelling: "You [METRIC] more than [PERCENTAGE]% of users"
- Plan fallback content for users with low activity (avoid making them feel excluded)
- Define minimum engagement threshold for receiving the recap vs. a simpler year-end message

### 2. THE OPENING — SETTING THE STAGE
- Write 3 subject line options that create anticipation: "Your [YEAR] in review is here" with a twist
- Open with a warm, reflective tone acknowledging the passage of time
- Include a personalized greeting: "[FIRST_NAME], what a year it has been"
- Set the stage with one sentence framing the year's theme or context
- Tease the stats to come: "We crunched the numbers, and here is your story"
- Include a branded header graphic placeholder [YEAR_IN_REVIEW_HEADER]

### 3. THE HIGHLIGHT STATS
- Present the top 3-4 most impressive personal metrics in a visually prominent format
- For each stat, include the number, a contextual label, and a reaction line
  - Example: "[TOTAL_HOURS] hours — That is like binge-watching [FUN_COMPARISON]"
- Use large typography placeholders to indicate visual hierarchy [STAT_DISPLAY_1], [STAT_DISPLAY_2]
- Include at least one fun or unexpected comparison to make the data relatable
- Add a "Your biggest [MONTH/DAY/MOMENT]" highlight for a personal touch
- Compare to their previous year if data is available: "Up [PERCENTAGE]% from last year"

### 4. ACHIEVEMENTS AND MILESTONES
- List the key milestones they hit during [YEAR]
- Frame achievements as a timeline or journey narrative
- Include badges, streaks, or unlock graphics if applicable [ACHIEVEMENT_BADGES]
- Highlight their "firsts": first project, first collaboration, first milestone
- Show cumulative impact: "All together, you [CUMULATIVE_IMPACT_STAT]"
- Include a "you were among the first to try [NEW FEATURE]" element if relevant

### 5. COMMUNITY AND COMPARATIVE CONTEXT
- Show where they rank within the community (top percentiles feel great)
- Share aggregate community stats: "Together, [BRAND/COMPANY NAME] users [COMMUNITY_STAT]"
- Include a fun superlative: "Most active [DAY_OF_WEEK]: [DAY]" or "Favorite [CATEGORY]: [TOP_CHOICE]"
- If applicable, highlight collaborative achievements or network growth
- Provide a "your type" or personality-based classification based on usage patterns
- Make comparisons celebratory, never competitive or shaming

### 6. THE SHARE AND FORWARD LOOK
- Include a prominently featured "Share Your Year" CTA with a personalized shareable graphic [SHARE_GRAPHIC_URL]
- Provide pre-written share text for social platforms with branded hashtag [HASHTAG]
- Add one-click share buttons for major platforms
- Transition to a forward-looking message: "Here is to an even bigger [NEXT_YEAR]"
- Set a goal or aspiration for the new year based on their trajectory
- Include a CTA to set a personal goal or explore a new feature for the coming year
- If applicable, tease upcoming product updates or features for [NEXT_YEAR]

### 7. TECHNICAL AND DESIGN SPECIFICATIONS
- Note the heavy reliance on dynamic data fields and conditional content blocks
- List all required merge tags and data sources
- Specify fallback content for each data point in case of missing data
- Recommend a mobile-first design approach given high share/screenshot rates
- Include accessibility notes: alt text for stats graphics, text alternatives for visual elements
- Suggest A/B testing the subject line and the order of stat presentation
- Note send timing: early-to-mid December for maximum engagement and shareability

Deliver the complete year-in-review email with all copy, data point specifications, visual layout descriptions, shareable graphic requirements, social share text, and technical implementation notes for the dynamic content rendering.

Be specific to my situation. No generic filler.
