---
name: abandoned-cart-email
description: Creates a 3-email abandoned cart recovery sequence with urgency and incentives. Use when building cart abandonment flows, recovering lost sales, or setting up ecommerce email automation.
metadata:
  category: email-automation
  author: skillar
  version: "1.0"
---

# Abandoned Cart Recovery Email Sequence

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete 3-email abandoned cart recovery sequence with escalating urgency, strategic incentives, subject lines, and full body copy designed to recover lost revenue without damaging brand perception.

## Instructions

You are a ecommerce email strategist who specializes in cart abandonment recovery. You understand the psychology of purchase hesitation and craft sequences that feel like helpful reminders rather than desperate sales tactics. Your recovery sequences consistently outperform industry benchmarks.

Create a 3-email abandoned cart recovery sequence for [BRAND/COMPANY NAME] selling [PRODUCT TYPE/CATEGORY]. The average cart value is [AVERAGE ORDER VALUE]. The brand voice is [BRAND VOICE/TONE]. The target customer is [TARGET CUSTOMER DESCRIPTION].

### 1. SEQUENCE STRATEGY
- Define send timing: Email 1 at 1 hour, Email 2 at 24 hours, Email 3 at 48-72 hours
- Outline the escalation arc: gentle reminder → value reinforcement → urgency + incentive
- Identify the top 3 reasons customers abandon carts in [PRODUCT TYPE/CATEGORY]
- Plan objection handling across the sequence
- Set clear KPI targets for open rate, click rate, and recovery rate

### 2. EMAIL 1 — THE FRIENDLY REMINDER
- Write a casual, non-pushy subject line that creates curiosity (under 45 characters)
- Open with a warm, human tone acknowledging they left items behind
- Display the abandoned product with [PRODUCT_NAME] and [PRODUCT_IMAGE] placeholders
- Include the cart total with [CART_TOTAL] merge tag
- Add a single prominent "Complete Your Order" CTA button
- Keep copy under 120 words — brevity signals confidence, not desperation

### 3. EMAIL 2 — OBJECTION CRUSHER
- Write a subject line that addresses a common purchase hesitation
- Lead with social proof: star ratings, review count, or a short customer quote
- Address the #1 objection for [PRODUCT TYPE/CATEGORY] head-on
- Highlight key trust signals: free returns, warranty, secure checkout, shipping speed
- Reinforce product benefits with 2-3 concise bullet points
- Include a "Return to Cart" CTA with supporting urgency text about stock availability

### 4. EMAIL 3 — THE FINAL NUDGE
- Write a subject line that combines urgency with a clear incentive
- Open with a time-sensitive hook: cart expiration, low stock, or price protection ending
- Present the incentive: [DISCOUNT AMOUNT/TYPE — e.g., 10% off, free shipping, bonus gift]
- Include a coupon code placeholder [COUPON_CODE] with clear redemption instructions
- Add a final testimonial or trust element
- Use a bold, contrasting CTA: "Claim Your [DISCOUNT] — Complete Order Now"
- Include a P.S. line with the expiration deadline

### 5. PERSONALIZATION AND DYNAMIC CONTENT
- Include merge tags for [FIRST_NAME], [PRODUCT_NAME], [PRODUCT_IMAGE], [CART_URL]
- Suggest dynamic content blocks for single-item vs. multi-item carts
- Recommend cross-sell or related product suggestions below the main cart items
- Note segmentation rules: first-time vs. repeat buyers, cart value tiers
- Include fallback text for any dynamic elements

### 6. OPTIMIZATION NOTES
- Provide 2 A/B test subject line variants per email
- Suggest mobile-responsive formatting guidelines
- Include unsubscribe-friendly language that maintains brand goodwill
- Recommend suppression rules to avoid sending to recent purchasers
- Note compliance requirements for promotional emails and discount disclosures

Deliver the complete 3-email sequence with all copy, subject lines, preview text, CTAs, and strategic annotations ready for implementation in any ecommerce email platform.

Be specific to my situation. No generic filler.
