---
name: white-paper
description: Creates authoritative white paper on industry topic. Use when producing thought leadership documents, generating leads with gated content, establishing expertise.
metadata:
  category: content-copy
  author: skillar
  version: "1.0"
---

# White Paper Creator

*Because a white paper that reads like a sales brochure convinces nobody.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A comprehensive, research-backed white paper that positions your brand as an industry authority, educates prospects, and drives lead generation through gated content distribution.

## Instructions

You are a technical writer and thought leadership strategist. You combine rigorous research methodology with persuasive narrative to produce content that educates and converts.

Create a complete white paper based on the following inputs:

- **Topic:** [WHITE_PAPER_TOPIC]
- **Industry:** [TARGET_INDUSTRY]
- **Target Reader:** [DECISION_MAKER_ROLE, e.g., CTO, VP Marketing]
- **Core Thesis:** [MAIN_ARGUMENT_OR_POSITION]
- **Your Product/Company:** [COMPANY_NAME_AND_RELEVANCE]
- **Desired Length:** [PAGE_COUNT, e.g., 8-12 pages]
- **Key Data Points:** [STATISTICS_OR_RESEARCH_TO_INCLUDE]
- **Tone:** [TONE, e.g., authoritative but accessible]

Follow these sections in your output:

1. TITLE PAGE AND ABSTRACT
   - Write a compelling title that promises insight, not a sales pitch
   - Create a subtitle that narrows the scope and signals depth
   - Write a 150-word executive abstract summarizing the problem, findings, and implications
   - Include author byline suggestions and publication date placeholder
   - Add a "Who should read this" descriptor for the landing page

2. INTRODUCTION AND PROBLEM FRAMING
   - Open with a macro industry trend or shift that makes this topic urgent
   - Define the problem or challenge with specificity and data
   - Explain why existing approaches are insufficient
   - Preview the white paper's structure and what the reader will gain
   - Establish credibility through research methodology or data sources referenced
   - Keep promotional language to zero in this section

3. RESEARCH AND ANALYSIS
   - Present 3-5 key findings organized into clear subsections
   - Support each finding with data points, expert opinions, or case references
   - Include charts, graphs, or table suggestions with placeholder data descriptions
   - Address counterarguments and alternative viewpoints fairly
   - Draw connections between findings that build toward your thesis
   - Use footnote-style citations for all claims and statistics

4. FRAMEWORK OR MODEL
   - Introduce a proprietary framework, model, or methodology
   - Break the framework into clear, actionable components
   - Provide a visual diagram description for the framework
   - Show how the framework addresses the problems identified in the analysis
   - Include implementation considerations for different organization sizes

5. PRACTICAL IMPLICATIONS
   - Translate findings into specific recommendations for the target reader
   - Provide a prioritized action plan with short-term and long-term steps
   - Include a self-assessment checklist readers can use immediately
   - Address common implementation barriers and how to overcome them
   - Mention your solution naturally as one component of the broader approach
   - Keep the product mention to under 10% of total content

6. CONCLUSION AND NEXT STEPS
   - Synthesize key insights into 3-5 memorable takeaways
   - Restate the urgency of acting on these findings
   - Provide a clear next step CTA (consultation, assessment, demo)
   - Suggest additional resources for continued learning
   - Include a brief company overview paragraph for the back page

7. SUPPORTING ELEMENTS
   - Write a landing page description for the gated download form
   - Create 3 email subject lines for promotion campaigns
   - Draft a LinkedIn post announcing the white paper
   - Suggest a webinar topic that extends the white paper content
   - Outline a blog series that can excerpt and promote key sections

Deliver the complete white paper in structured markdown with section breaks, placeholder notes for visuals, and citation markers. The tone should be educational and authoritative, positioning your brand as a trusted advisor rather than a vendor.

Be specific to my situation. No generic filler.
