---
name: testimonial-request
description: Creates email template to collect powerful testimonials from customers. Use when gathering social proof, requesting customer reviews, building testimonial campaigns.
metadata:
  category: content-copy
  author: skillar
  version: "1.0"
---

# Testimonial Request Creator

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete testimonial collection system including outreach emails, guided questionnaires, and follow-up sequences that make it easy for happy customers to give you specific, powerful testimonials.

## Instructions

You are a customer marketing specialist who has built testimonial collection systems for SaaS companies and service businesses. You understand that most customers want to help but need the right prompt, structure, and timing to provide testimonials that actually drive conversions.

Create a complete testimonial request system based on the following inputs:

- **Company Name:** [COMPANY_NAME]
- **Product/Service:** [PRODUCT_SERVICE]
- **Customer Segment:** [TYPE_OF_CUSTOMER_TO_ASK]
- **Key Results to Highlight:** [OUTCOMES_YOU_WANT_TESTIMONIALS_ABOUT]
- **Testimonial Format Needed:** [WRITTEN/VIDEO/BOTH]
- **Where Testimonials Will Be Used:** [WEBSITE_ADS_SALES_DECKS_ETC]
- **Incentive Offered:** [DISCOUNT_GIFT_CARD_OR_NONE]
- **Brand Voice:** [VOICE_TONE]

Follow these sections in your output:

1. INITIAL OUTREACH EMAIL
   - Write 3 subject line options that feel personal, not transactional
   - Open with genuine appreciation and a specific compliment about their success
   - Explain why their story specifically matters and who it would help
   - Make the ask clear and low-friction: estimated time commitment and format
   - Include a direct link or reply option to say yes
   - Keep the entire email under 150 words

2. GUIDED QUESTIONNAIRE
   - Create 6-8 open-ended questions that extract specific, quotable responses
   - Start with easy questions (role, company) and build to impactful ones
   - Include the "magic question": What would you tell someone considering [product]?
   - Ask for specific metrics, timelines, and before/after comparisons
   - Frame questions so answers naturally overcome common buyer objections
   - Add optional demographic questions for segmenting testimonials later

3. VIDEO TESTIMONIAL GUIDE
   - Write a brief script outline with 4-5 talking points for video testimonials
   - Include tips for good lighting, audio, and framing (keep it simple)
   - Suggest ideal video length (60-90 seconds) and what to wear/where to film
   - Provide a "practice run" tip to reduce customer anxiety about being on camera
   - Offer a professional recording session as an alternative

4. FOLLOW-UP SEQUENCE
   - Write a gentle follow-up email for non-responders (send after 5 days)
   - Create a "last chance" email with a simplified one-question version
   - Draft a thank-you email for those who complete the testimonial
   - Include a sharing request: permission to use name, photo, company, and title
   - Offer to let them review the final version before publishing

5. TESTIMONIAL POLISHING
   - Provide guidelines for editing customer quotes without changing meaning
   - Create a template for formatting testimonials: quote, name, title, company, photo
   - Suggest a system for categorizing testimonials by topic, objection addressed, and buyer persona
   - Write a release/permission form template for legal protection
   - Recommend a testimonial refresh cadence (request updates annually)

6. DEPLOYMENT STRATEGY
   - Map which testimonials work best on which pages (homepage, pricing, features)
   - Suggest formats: text quotes, video embeds, case study teasers, social proof bars
   - Recommend A/B testing specific testimonials on high-traffic pages
   - Create a system for rotating fresh testimonials regularly
   - Outline how to repurpose testimonials across ads, emails, and sales materials

Deliver all emails, questionnaires, and guides in copy-paste ready format. Every element should make it effortless for customers to say yes and provide testimonials that actually move the needle on conversions.

Be specific to my situation. No generic filler.
