---
name: storytelling-framework
description: Builds brand storytelling framework using hero's journey. Use when developing brand narrative, creating origin stories, building emotional brand connection.
metadata:
  category: content-copy
  author: skillar
  version: "1.0"
---

# Storytelling Framework Builder

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete brand storytelling framework that maps your brand's narrative using the hero's journey structure, with reusable story templates, character archetypes, and a narrative playbook for every content channel.

## Instructions

You are a brand narrative strategist who has studied under the principles of Joseph Campbell, Donald Miller (StoryBrand), and modern narrative branding. You understand how to position the customer as the hero and the brand as the guide, creating stories that forge deep emotional connections and drive action.

Build a complete storytelling framework based on the following inputs:

- **Company/Brand Name:** [COMPANY_NAME]
- **What You Sell:** [PRODUCT_SERVICE]
- **Your Customer:** [CUSTOMER_DESCRIPTION_AND_DEMOGRAPHICS]
- **Customer's Core Problem:** [PRIMARY_PAIN_POINT]
- **Customer's Desired Transformation:** [IDEAL_OUTCOME]
- **Brand Origin Story:** [FOUNDING_STORY_OR_KEY_MOMENTS]
- **Core Values:** [BRAND_VALUES]
- **Competitors' Narrative Approach:** [HOW_COMPETITORS_TELL_THEIR_STORY]

Follow these sections in your output:

1. NARRATIVE POSITIONING
   - Define the customer as the hero and map their current state (the "ordinary world")
   - Position the brand as the guide with empathy and authority
   - Identify the villain: the external problem, internal frustration, and philosophical wrong
   - Articulate the transformation promise: from where the hero is to where they want to be
   - Differentiate your narrative from competitors' storytelling approach
   - Write a one-sentence brand narrative statement that encapsulates the entire story

2. HERO'S JOURNEY MAP
   - Map the customer's journey through 7 narrative stages adapted for brand storytelling
   - Stage 1: The Ordinary World (customer's life before your brand)
   - Stage 2: The Call to Adventure (the moment they realize they need change)
   - Stage 3: Meeting the Guide (how they discover your brand)
   - Stage 4: The Plan (how your product/service creates a clear path)
   - Stage 5: The Action (the moment of purchase or commitment)
   - Stage 6: The Transformation (results and new reality)
   - Stage 7: The New Identity (who the customer becomes and how they share the story)

3. CHARACTER ARCHETYPES
   - Define your brand's archetype (Sage, Hero, Creator, Explorer, etc.) with rationale
   - Describe your customer's archetype and how it interacts with yours
   - Create a villain archetype that represents the problem your brand solves
   - Write a supporting cast: team members, partners, or community as characters
   - Define the emotional tone each character brings to the narrative
   - Explain how these archetypes should manifest in visual and verbal branding

4. STORY TEMPLATES
   - Create 5 reusable story structures for different content contexts
   - Customer success story template: situation, struggle, solution, success
   - Origin story template: the moment of inspiration, the challenge, the breakthrough
   - "Day in the life" template: showing transformation through mundane details
   - Underdog story template: overcoming odds that the audience relates to
   - Vision story template: painting the future the brand is building toward
   - For each template, provide a fill-in-the-blank framework and a sample paragraph

5. CHANNEL APPLICATION
   - Adapt the core narrative for website (homepage, about, product pages)
   - Create story hooks for social media (Instagram, LinkedIn, Twitter)
   - Define storytelling approach for email sequences (welcome, nurture, conversion)
   - Map the narrative to sales presentations and pitch decks
   - Suggest video storytelling formats and scripts for key brand stories
   - Include storytelling guidelines for customer-facing team members

6. NARRATIVE CONSISTENCY SYSTEM
   - Create a story bank structure for organizing brand stories by theme and format
   - Define a narrative review checklist: Does this content follow our story framework?
   - Establish a process for capturing new customer stories systematically
   - Set guidelines for how much of the origin story to reveal in different contexts
   - Include a quarterly narrative audit to keep stories fresh and relevant
   - Write an internal one-page summary any team member can reference

Deliver the framework as a strategic document with clear, actionable sections. Every element should help the team tell consistent, emotionally resonant stories that make the customer the hero and the brand the trusted guide.

Be specific to my situation. No generic filler.
