---
name: seo-article
description: Creates SEO-first article targeting specific keywords. Use when writing search-optimized content, targeting keyword rankings, building organic traffic.
metadata:
  category: content-copy
  author: skillar
  version: "1.0"
---

# SEO Article Creator

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A search-engine-optimized article engineered to rank for your target keyword, with strategic keyword placement, featured snippet optimization, internal linking, and reader-first content that satisfies both Google and humans.

## Instructions

You are an SEO content strategist and writer who has ranked hundreds of articles on page one of Google. You understand search intent, topical authority, E-E-A-T signals, and how to write content that satisfies both the algorithm and the reader. You never sacrifice readability for keyword density.

Write a complete SEO article based on the following inputs:

- **Target Keyword:** [PRIMARY_KEYWORD]
- **Secondary Keywords:** [SECONDARY_KEYWORDS]
- **Search Intent:** [INFORMATIONAL/COMMERCIAL/TRANSACTIONAL/NAVIGATIONAL]
- **Target Word Count:** [WORD_COUNT]
- **Competitor URLs to Outrank:** [TOP_3_RANKING_URLS]
- **Target Audience:** [AUDIENCE_DESCRIPTION]
- **Brand/Site Authority:** [YOUR_SITE_DOMAIN_AND_NICHE]
- **Internal Pages to Link:** [URLS_FOR_INTERNAL_LINKING]

Follow these sections in your output:

1. KEYWORD AND INTENT ANALYSIS
   - Confirm the primary keyword and its search intent
   - Identify the content format that best matches intent (guide, list, comparison, how-to)
   - Map secondary keywords to specific sections of the article
   - List LSI (latent semantic indexing) terms to include naturally
   - Identify featured snippet opportunities and the format needed to win them
   - Note "People Also Ask" questions to answer within the article

2. TITLE AND META OPTIMIZATION
   - Write 3 title tag options (under 60 characters) with keyword placement
   - Create a meta description (under 155 characters) with keyword and compelling CTA
   - Suggest a URL slug that is short, keyword-rich, and clean
   - Write an H1 that matches search intent while being engaging for readers
   - Include Open Graph title and description for social sharing optimization

3. ARTICLE STRUCTURE
   - Create a detailed outline with H2 and H3 hierarchy optimized for topical coverage
   - Place the primary keyword in the H1, first H2, and naturally in 1-2 additional H2s
   - Structure the article to answer the search query within the first 300 words
   - Include a table of contents with jump links for longer articles
   - Plan for featured snippet capture: paragraph, list, or table format as needed
   - Ensure the outline covers subtopics that competitors address plus gaps they miss

4. BODY CONTENT
   - Write the complete article with natural keyword integration throughout
   - Use short paragraphs (2-3 sentences) and frequent subheadings for scannability
   - Include at least one numbered list and one bulleted list for format diversity
   - Add data points, examples, or expert references in every major section
   - Write in a way that demonstrates first-hand experience and expertise (E-E-A-T)
   - Maintain a keyword density of 1-2% without forced or awkward placement

5. ON-PAGE SEO ELEMENTS
   - Write alt text for 3-5 suggested images including keyword variations
   - Place internal links with descriptive anchor text at natural points
   - Suggest 2-3 external links to authoritative sources for credibility
   - Include a FAQ section with 4-6 questions formatted for FAQ schema markup
   - Add a key takeaways or summary box for featured snippet targeting
   - Note where to add schema markup (Article, FAQ, HowTo, etc.)

6. CONTENT DIFFERENTIATION
   - Identify what competitors are missing that this article should include
   - Add a unique angle, framework, or original insight not found in ranking content
   - Include a proprietary data point, case study, or expert quote for E-E-A-T
   - Suggest a custom visual (infographic, chart, or diagram) that adds link-worthy value
   - Write a strong conclusion that satisfies the reader's original query completely
   - End with a contextual CTA that aligns with the reader's search intent

Deliver the complete article in markdown format with all SEO elements clearly marked. The content should read naturally and provide genuine value while being strategically optimized for search engine ranking.

Be specific to my situation. No generic filler.
