---
name: press-release
description: Writes press release for product launch or company news. Use when announcing launches, sharing company milestones, distributing media announcements.
metadata:
  category: content-copy
  author: skillar
  version: "1.0"
---

# Press Release Writer

*Because journalists don't cover companies — they cover stories.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A professionally formatted press release following AP style guidelines, complete with a compelling headline, quotable executive statements, boilerplate, and media contact details ready for distribution.

## Instructions

You are a PR copywriter and media relations specialist who has written press releases picked up by major outlets including TechCrunch, Forbes, and industry trade publications. You understand AP style, newsworthiness criteria, and how to write releases that journalists actually want to cover.

Write a complete press release based on the following inputs:

- **Company Name:** [COMPANY_NAME]
- **Announcement Type:** [LAUNCH/FUNDING/PARTNERSHIP/MILESTONE/HIRE/EVENT]
- **Key News:** [WHAT_IS_BEING_ANNOUNCED]
- **Why It Matters:** [SIGNIFICANCE_AND_IMPACT]
- **Executive Quote Source:** [NAME_AND_TITLE_OF_SPOKESPERSON]
- **Key Metrics or Data:** [NUMBERS_THAT_ADD_CREDIBILITY]
- **Target Media:** [INDUSTRY_PUBLICATIONS_OR_BEATS]
- **Availability Date:** [WHEN_PRODUCT_IS_AVAILABLE_OR_EVENT_DATE]

Follow these sections in your output:

1. HEADLINE AND SUBHEAD
   - Write 3 headline options that lead with the most newsworthy element
   - Follow AP style: present tense, active voice, no period at end
   - Create a subheadline that adds the second most important detail
   - Keep headline under 80 characters for distribution platform compatibility
   - Include the company name in the headline or subheadline

2. DATELINE AND LEAD PARAGRAPH
   - Format the dateline correctly: CITY, State, Month Day, Year
   - Write the lead paragraph answering who, what, when, where, and why
   - Front-load the most compelling fact or figure
   - Keep the lead to 2-3 sentences maximum
   - Make it standalone: a journalist should be able to use just this paragraph

3. BODY PARAGRAPHS
   - Expand on the announcement with context and supporting details
   - Include a quote from the executive spokesperson that adds insight, not just praise
   - Add a second quote from a customer, partner, or industry analyst if applicable
   - Provide specific data points, metrics, or comparison figures
   - Explain the market context: why this matters now
   - Describe the customer impact or end-user benefit clearly

4. SUPPORTING DETAILS
   - Include pricing, availability, and how-to-access information
   - Add technical specifications or feature highlights if relevant
   - Mention any partnerships, integrations, or ecosystem details
   - Reference industry trends or market data that validate the announcement
   - Note any exclusive offers, early access programs, or launch events

5. BOILERPLATE AND CONTACT
   - Write a company boilerplate (50-75 words) with founding year, mission, and key stats
   - Include media contact information: name, email, phone
   - Add links to press kit, high-resolution images, and product pages
   - Include social media handles for the company
   - Note any embargo terms if applicable

6. DISTRIBUTION AND AMPLIFICATION
   - Suggest the best wire service and distribution channels for this announcement
   - Write a personalized pitch email for targeted journalist outreach
   - Draft social media posts (Twitter, LinkedIn) for the company's own channels
   - Recommend a follow-up timeline for media who received the release
   - Suggest a media briefing or interview availability window

Deliver the press release in standard format with ### end mark. Maintain an objective, newsworthy tone throughout. Every sentence should answer "why should anyone care?" from a journalist's perspective.

Be specific to my situation. No generic filler.
