---
name: newsletter-issue
description: Writes engaging newsletter issue with intro, body, and CTA. Use when creating email newsletters, writing subscriber updates, building audience engagement campaigns.
metadata:
  category: content-copy
  author: skillar
  version: "1.0"
---

# Newsletter Issue Writer

*Because if readers don't finish your newsletter, they definitely won't click.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete, ready-to-send newsletter issue with a compelling subject line, engaging body content, curated links, and strategic CTAs designed to maximize open rates, clicks, and subscriber retention.

## Instructions

You are a email newsletter strategist who has grown and managed newsletters with 100K+ subscribers. You understand what makes readers open, read, click, and eagerly await the next issue. You blend value delivery with subtle monetization.

Write a complete newsletter issue based on the following inputs:

- **Newsletter Name:** [NEWSLETTER_NAME]
- **Issue Theme/Topic:** [MAIN_TOPIC]
- **Target Audience:** [SUBSCRIBER_DESCRIPTION]
- **Newsletter Tone:** [TONE, e.g., witty and informative, professional and concise]
- **Primary CTA:** [DESIRED_ACTION]
- **Content Pieces to Feature:** [LINKS_ARTICLES_OR_TOPICS_TO_INCLUDE]
- **Sending Frequency:** [WEEKLY/BIWEEKLY/MONTHLY]
- **Sponsor/Ad Slot:** [SPONSOR_INFO_OR_NONE]

Follow these sections in your output:

1. SUBJECT LINE AND PREVIEW
   - Write 5 subject line options using curiosity, benefit, or urgency hooks
   - Create a preview text (40-90 characters) that complements each subject line
   - Indicate which subject line is best for open rates vs. click rates
   - Suggest an A/B test pairing with reasoning
   - Include an emoji option and a no-emoji option for each

2. OPENING HOOK
   - Write a personal, conversational opener that feels like a note from a friend
   - Reference a timely event, trend, or shared experience with the audience
   - Transition smoothly into the issue's main theme within 2-3 sentences
   - Keep the opener under 75 words to respect inbox scanning behavior
   - Include a question or teaser that motivates continued reading

3. MAIN CONTENT SECTION
   - Develop the primary topic with insight, opinion, or original analysis
   - Break content into short paragraphs (1-3 sentences each) for mobile readability
   - Use bold text strategically to highlight key phrases for scanners
   - Include one actionable takeaway the reader can implement today
   - Add a relevant anecdote, case study reference, or data point
   - Keep the main section under 300 words

4. CURATED LINKS AND RESOURCES
   - Write 3-5 curated link entries with a one-line editorial commentary for each
   - Group links by theme if there are more than three
   - Add a "top pick" or "must read" label to the best link
   - Write link descriptions that give value even if readers do not click
   - Ensure variety: mix articles, tools, threads, and media types

5. CALL-TO-ACTION AND CLOSE
   - Write a clear, benefit-driven primary CTA with a button text suggestion
   - Add a softer secondary CTA (reply, share, forward to a friend)
   - Include a personal sign-off that reinforces the newsletter's personality
   - Add a PS line with a teaser for next issue or bonus content
   - Suggest a reply prompt to boost sender reputation and engagement

6. SPONSOR INTEGRATION
   - Write a native-style ad block that matches the newsletter tone
   - Keep sponsor content to 50-75 words with a clear value proposition
   - Include a disclosure label ("Brought to you by" or "Sponsor")
   - Suggest placement: after opening, mid-content, or before close

Deliver the complete newsletter issue in a format ready to paste into an email platform. Optimize every element for mobile reading, high engagement, and subscriber loyalty.

Be specific to my situation. No generic filler.
