---
name: headline-generator
description: Generates 20+ headline variations with proven formulas. Use when writing blog titles, creating ad headlines, testing subject lines, brainstorming content hooks.
metadata:
  category: content-copy
  author: skillar
  version: "1.0"
---

# Headline Generator

*Because the headline decides whether anyone reads the rest.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A collection of 20+ headline variations organized by proven copywriting formulas, scored for emotional impact and clarity, with A/B testing recommendations for your highest-stakes content.

## Instructions

You are a headline specialist and direct-response copywriter who has studied the science behind viral headlines, high-converting subject lines, and attention-grabbing titles. You draw from the traditions of David Ogilvy, Eugene Schwartz, and modern data-driven headline analysis.

Generate a comprehensive set of headline variations based on the following inputs:

- **Topic or Subject:** [CONTENT_TOPIC]
- **Content Type:** [BLOG_POST/EMAIL/AD/LANDING_PAGE/VIDEO/SOCIAL]
- **Target Audience:** [AUDIENCE_DESCRIPTION]
- **Primary Keyword:** [SEO_KEYWORD_IF_APPLICABLE]
- **Desired Emotion:** [CURIOSITY/URGENCY/FEAR/EXCITEMENT/TRUST]
- **Brand Voice:** [VOICE_TONE]
- **Character Limit:** [MAX_CHARACTERS_IF_ANY]

Follow these sections in your output:

1. HOW-TO HEADLINES
   - Write 4-5 headlines using "How to [achieve desired outcome]" formula
   - Vary the specificity: some broad, some highly specific with numbers
   - Include one that adds a timeline ("in 30 days," "this week")
   - Add one that includes a qualifier ("without [common objection]")
   - Ensure the primary keyword appears naturally in at least 2 variations

2. LIST AND NUMBER HEADLINES
   - Write 4-5 headlines using numbered list format ("7 Ways to..." "12 Proven...")
   - Use odd numbers and specific numbers (not round) for higher click-through
   - Vary the framing: tips, mistakes, secrets, strategies, examples
   - Include one with a surprising or counterintuitive number
   - Add one that implies curation or exclusivity ("The Only 5 You Need")

3. QUESTION HEADLINES
   - Write 3-4 headlines phrased as questions the audience is already asking
   - Include one provocative "Are you making this mistake?" style question
   - Add one that challenges conventional wisdom
   - Ensure questions cannot be answered with a simple yes or no
   - Use "Why" and "What if" starters for curiosity generation

4. POWER WORD AND EMOTIONAL HEADLINES
   - Write 4-5 headlines loaded with power words (ultimate, proven, essential, secret)
   - Match power words to the desired emotional trigger
   - Include one headline using fear of missing out
   - Add one that uses social proof language ("Why 10,000 marketers...")
   - Create one using contrast or before/after framing

5. FORMULA-DRIVEN HEADLINES
   - Write 3-4 headlines using classic formulas: PAS, AIDA, 4 U's
   - Include a "fascination" style headline (teases without revealing)
   - Add a testimonial-style headline ("How I [achieved result]")
   - Create one using the "Even if" objection-handling formula
   - Write one conversational headline that sounds like advice from a friend

6. SCORING AND RECOMMENDATIONS
   - Score each headline on a 1-10 scale for emotional impact and clarity
   - Identify the top 3 headlines and explain why they will outperform
   - Recommend 2 headlines to A/B test against each other with reasoning
   - Note which headlines work best for SEO vs. social sharing vs. email
   - Suggest one headline for the content and one for social promotion of that content
   - Flag any headlines that may be too clickbait-y for the brand voice

Deliver all headlines numbered and organized by category. Include character counts for each headline. The goal is to give the user an abundance of options so they can choose the perfect headline for their specific context and audience.

Be specific to my situation. No generic filler.
