---
name: faq-page
description: Generates FAQ page that addresses objections and improves SEO. Use when building FAQ sections, handling customer objections, creating help center content.
metadata:
  category: content-copy
  author: skillar
  version: "1.0"
---

# FAQ Page Generator

*Because a good FAQ page is a sales page in disguise.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A strategically organized FAQ page that answers real customer questions, overcomes buying objections, captures featured snippet rankings, and reduces support ticket volume.

## Instructions

You are a conversion copywriter and SEO specialist who understands that FAQ pages are one of the highest-converting and most SEO-valuable pages on any website. You craft answers that inform, reassure, and subtly sell.

Create a complete FAQ page based on the following inputs:

- **Product/Service:** [PRODUCT_SERVICE_NAME]
- **Industry:** [INDUSTRY]
- **Target Audience:** [AUDIENCE_DESCRIPTION]
- **Common Customer Questions:** [LIST_OF_KNOWN_QUESTIONS]
- **Top Buying Objections:** [PRICE_TRUST_COMPLEXITY_ETC]
- **Support Ticket Themes:** [COMMON_SUPPORT_ISSUES]
- **Competitors:** [COMPETITOR_NAMES_FOR_COMPARISON_QUESTIONS]
- **Brand Voice:** [VOICE_TONE]

Follow these sections in your output:

1. FAQ STRATEGY AND ORGANIZATION
   - Organize questions into 4-6 logical categories (Getting Started, Pricing, Features, etc.)
   - Prioritize questions by frequency and conversion impact
   - Identify 5 questions specifically targeting featured snippet opportunities
   - Map each question to a stage in the buyer's journey (awareness, consideration, decision)
   - Include questions prospects ask but are too polite to voice (price, competitors, risk)

2. GENERAL QUESTIONS
   - Write 5-7 foundational questions and answers about the product/service
   - Answer each question in 2-4 sentences that are clear and jargon-free
   - Open each answer with a direct response before adding context
   - Include one answer that naturally links to a detailed resource or blog post
   - Use the customer's language, not internal company terminology
   - Embed primary keywords naturally in both questions and answers

3. OBJECTION-HANDLING QUESTIONS
   - Write 4-6 questions that directly address buying hesitations
   - Handle price objections with value framing, not defensiveness
   - Address trust concerns with social proof and guarantees
   - Tackle complexity worries with simplicity-focused answers
   - Answer "Why you vs. competitor X?" without naming competitors negatively
   - Include risk-reversal language (guarantees, trials, easy cancellation)

4. TECHNICAL AND SUPPORT QUESTIONS
   - Write 4-6 questions about implementation, integration, or product specifics
   - Provide step-by-step answers where appropriate
   - Include links to documentation, tutorials, or support resources
   - Address the top 3 support ticket topics to deflect repetitive inquiries
   - Add troubleshooting guidance for common issues

5. SEO AND SCHEMA OPTIMIZATION
   - Format all Q&As for FAQ schema markup (provide the JSON-LD structure)
   - Write questions as natural search queries people would type into Google
   - Keep answers concise enough for featured snippet capture (40-60 words ideal)
   - Include long-tail keyword variations in question phrasing
   - Suggest internal links from FAQ answers to relevant product or content pages

6. PAGE DESIGN AND UX
   - Recommend accordion vs. full-display layout based on question volume
   - Include a search bar suggestion for pages with 20+ questions
   - Add a "still have questions?" CTA at the bottom with contact options
   - Suggest a feedback mechanism ("Was this helpful? Yes/No") for each answer
   - Recommend placement of the FAQ link in site navigation and footer

Deliver all questions and answers organized by category, with schema markup code included. Each answer should inform while gently reinforcing why your product is the right choice.

Be specific to my situation. No generic filler.
