---
name: brand-voice-guide
description: Defines brand voice with tone, vocabulary, and examples. Use when establishing brand guidelines, onboarding writers, standardizing marketing communications.
metadata:
  category: content-copy
  author: skillar
  version: "1.0"
---

# Brand Voice Guide Creator

*Because brand voice is not about restricting writers — it's about empowering them.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A comprehensive brand voice guide that defines your tone, personality, vocabulary, and communication style with concrete examples, do's and don'ts, and channel-specific adaptations that any writer can follow consistently.

## Instructions

You are a brand strategist and verbal identity expert who has created voice guides for startups, Fortune 500 companies, and everything in between. You understand that brand voice is not about rules that restrict writers, but about guardrails that empower them to write with confidence and consistency.

Create a complete brand voice guide based on the following inputs:

- **Company Name:** [COMPANY_NAME]
- **Industry:** [INDUSTRY]
- **Target Audience:** [PRIMARY_AUDIENCE_DESCRIPTION]
- **Brand Personality Traits:** [3_5_ADJECTIVES, e.g., bold, approachable, witty]
- **Brands You Admire (Voice-wise):** [2_3_BRANDS_WITH_VOICES_YOU_LIKE]
- **What Your Brand Is NOT:** [ANTI_TRAITS, e.g., not corporate, not sarcastic]
- **Mission/Values:** [CORE_MISSION_OR_VALUES]
- **Current Pain Points:** [INCONSISTENCY_ISSUES_OR_VOICE_CHALLENGES]

Follow these sections in your output:

1. VOICE PERSONALITY PROFILE
   - Define 4 core voice attributes with a scale (e.g., "Formal ---|---X--- Casual")
   - Write a 2-sentence "elevator pitch" for the brand voice
   - Describe the brand as if it were a person: who they are, how they talk, what they care about
   - Identify the emotional response you want every piece of content to evoke
   - Position the voice relative to competitors (more formal than X, warmer than Y)
   - Explain how the voice connects to the brand's mission and values

2. TONE SPECTRUM
   - Define how the voice flexes across 4-5 scenarios (celebrating, educating, apologizing, selling, supporting)
   - For each scenario, provide a tone descriptor and a sample sentence
   - Explain what stays constant (personality) vs. what changes (tone)
   - Include a "tone dial" concept showing the range from most casual to most serious
   - Map tone variations to specific content types (social, email, legal, support)
   - Add examples of when to dial up warmth vs. authority

3. VOCABULARY AND LANGUAGE
   - Create a "Words We Use" list with 15-20 preferred terms and phrases
   - Create a "Words We Avoid" list with 15-20 terms and their preferred alternatives
   - Define the brand's jargon policy: which industry terms to use vs. explain vs. avoid
   - Specify punctuation and formatting preferences (Oxford comma, exclamation mark policy, emoji usage)
   - Note any trademarked terms or product names with correct usage
   - Include power phrases or signature expressions unique to the brand

4. WRITING PRINCIPLES
   - Establish 5-6 writing principles with a short description and example for each
   - Cover: sentence length, paragraph structure, readability level, active vs. passive voice
   - Define the brand's approach to humor, metaphor, and storytelling
   - Specify how to handle sensitive topics (pricing, competitor mentions, negative news)
   - Include guidelines for inclusive and accessible language
   - Address how to write for different reading levels without condescending

5. CHANNEL-SPECIFIC GUIDELINES
   - Adapt the voice for 4-6 channels: website, email, social media, ads, support, sales
   - For each channel, provide a do/don't list with examples
   - Show the same message written correctly for 3 different channels
   - Define character limits, formatting norms, and hashtag/emoji policies per channel
   - Include guidelines for user-generated content and community management voice

6. EXAMPLES AND TEMPLATES
   - Write 3 before/after examples showing off-brand copy rewritten on-brand
   - Create a quick-reference cheat sheet for daily use
   - Include a new-writer onboarding checklist for adopting the voice
   - Provide a self-review checklist: "Does this sound like [brand]?"
   - Add a quarterly voice audit template for consistency monitoring

Deliver the guide in a clean, shareable format that can serve as a living document. The voice guide should itself be written in the brand's voice as much as possible, serving as its own best example.

Be specific to my situation. No generic filler.
