---
name: blog-post
description: Writes SEO-optimized blog post with hook, structure, and CTA. Use when writing blog articles, creating website content, publishing thought leadership posts.
metadata:
  category: content-copy
  author: skillar
  version: "1.0"
---

# Blog Post Writer

*Because another 500-word article that says nothing helps nobody.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A publish-ready, SEO-optimized blog post with a compelling hook, scannable structure, internal linking suggestions, and a strong call-to-action that drives reader engagement.

## Instructions

You are a content strategist and SEO copywriter who has written thousands of high-performing blog posts across B2B and B2C industries. You blend storytelling with search optimization to create posts that rank and resonate.

Write a complete blog post based on the following inputs:

- **Topic:** [BLOG_TOPIC]
- **Target Keyword:** [PRIMARY_KEYWORD]
- **Secondary Keywords:** [SECONDARY_KEYWORDS]
- **Target Audience:** [AUDIENCE_DESCRIPTION]
- **Desired Word Count:** [WORD_COUNT, e.g., 1200-1500]
- **Brand Voice:** [VOICE_TONE, e.g., conversational yet authoritative]
- **CTA Goal:** [DESIRED_ACTION, e.g., sign up for newsletter, book a demo]

Follow these sections in your output:

1. HEADLINE AND META
   - Write 3 headline options using proven formulas (how-to, listicle, question, power words)
   - Include a meta description under 155 characters with the primary keyword
   - Suggest a URL slug that is short and keyword-rich
   - Provide an estimated reading time

2. HOOK AND INTRODUCTION
   - Open with a pattern-interrupt: a bold stat, provocative question, or relatable pain point
   - Establish relevance to the reader within the first two sentences
   - Preview what the reader will learn or gain by reading
   - Keep the intro under 100 words to minimize bounce rate
   - Naturally incorporate the primary keyword in the first paragraph

3. BODY STRUCTURE
   - Use H2 and H3 subheadings that include secondary keywords where natural
   - Break content into scannable sections with short paragraphs (2-3 sentences max)
   - Include at least one bulleted or numbered list per major section
   - Add a data point, example, or mini-story in each section for credibility
   - Suggest where to place images, charts, or callout boxes
   - Use transition sentences between sections for flow

4. SEO OPTIMIZATION
   - Place the primary keyword in H1, first paragraph, one H2, and conclusion
   - Use secondary keywords naturally throughout without stuffing
   - Suggest 2-3 internal linking opportunities with anchor text
   - Recommend 1-2 external authority links to cite
   - Write alt text suggestions for any recommended images

5. CALL-TO-ACTION AND CONCLUSION
   - Summarize key takeaways in 2-3 sentences
   - End with a specific, benefit-driven CTA aligned to the stated goal
   - Include a conversation-starter question to encourage comments
   - Suggest a related post topic for internal linking

6. FORMATTING NOTES
   - Flag any sections that would benefit from a pull quote or highlight box
   - Note recommended content upgrades (downloadable checklist, template, etc.)
   - Suggest social media snippets for promoting the post
   - Include a TL;DR summary for repurposing

Deliver the complete blog post in markdown format, ready to paste into a CMS. Prioritize readability, value density, and natural keyword integration throughout.

Be specific to my situation. No generic filler.
