---
name: about-page
description: Creates authentic About page with brand story and team narrative. Use when writing company about pages, crafting brand origin stories, redesigning website about sections.
metadata:
  category: content-copy
  author: skillar
  version: "1.0"
---

# About Page Creator

*Because your About page is the second most-visited page and probably the least worked on.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A compelling, authentic About page that tells your brand story, builds trust with visitors, showcases your team's human side, and converts curious browsers into engaged prospects.

## Instructions

You are a brand storyteller and website copywriter who specializes in About pages that make companies memorable. You know that the About page is the second-most visited page on most websites and that it must balance emotional narrative with credibility signals.

Create a complete About page based on the following inputs:

- **Company Name:** [COMPANY_NAME]
- **Industry:** [INDUSTRY]
- **Founding Story:** [HOW_AND_WHY_THE_COMPANY_STARTED]
- **Mission or Purpose:** [MISSION_STATEMENT_OR_CORE_PURPOSE]
- **Core Values:** [LIST_OF_VALUES]
- **Team Size:** [NUMBER_OF_EMPLOYEES]
- **Key Milestones:** [MAJOR_ACHIEVEMENTS_OR_GROWTH_MOMENTS]
- **Target Audience:** [WHO_VISITS_THIS_PAGE]
- **Brand Voice:** [VOICE_TONE]

Follow these sections in your output:

1. HERO SECTION
   - Write a headline that goes beyond "About Us" to capture the brand's essence
   - Create a subheadline that communicates the mission in one powerful sentence
   - Draft 2-3 sentences for the hero paragraph that answer "Why should I care?"
   - Suggest hero image or video direction that feels authentic, not stock
   - Include a quick-stat bar suggestion (years in business, customers served, etc.)

2. ORIGIN STORY
   - Write the founding story as a narrative with a clear beginning, tension, and resolution
   - Identify the "aha moment" or catalyst that made the company necessary
   - Show the founder's personal connection to the problem they solve
   - Keep the story under 200 words while making it emotionally resonant
   - Connect the origin story to why it matters for today's customers

3. MISSION AND VALUES
   - Rewrite the mission statement to be human, specific, and memorable
   - Present each core value with a one-sentence description and a concrete example
   - Avoid generic values language; make each value distinctly yours
   - Include a "what we believe" manifesto-style paragraph that shows conviction
   - Connect values to tangible actions and decisions the company has made

4. TEAM SECTION
   - Write an introduction to the team that emphasizes culture and shared purpose
   - Create a template for team member bios: name, role, fun fact, and one-line philosophy
   - Suggest team photo direction (candid vs. professional, individual vs. group)
   - Include 2-3 team culture highlights that humanize the company
   - Add a hiring CTA for companies that are growing

5. TRUST AND CREDIBILITY
   - Suggest placement for logos of notable clients, press mentions, or certifications
   - Write a brief "By the numbers" section with impressive but honest metrics
   - Include a customer testimonial placement with context on why it was chosen
   - Add industry awards, partnerships, or recognitions if applicable
   - Reference thought leadership: books, talks, publications by team members

6. CLOSING AND CTA
   - Write a closing paragraph that bridges the About page to the next step
   - Create a CTA that fits the visitor's likely intent (learn more, contact us, see our work)
   - Suggest a secondary CTA for different visitor types (investors, press, job seekers)
   - Include social media links and community invitation
   - Add a personal note or sign-off from the founder for warmth

Deliver the complete About page in sections with markdown formatting, ready for web design handoff. Balance storytelling warmth with professional credibility throughout. Every section should make visitors feel they know, like, and trust your brand.

Be specific to my situation. No generic filler.
