---
name: waitlist-builder
description: Designs a waitlist strategy that builds hype and converts to customers. Use when building a waitlist, pre-launch sign-ups, generating early demand, or creating urgency before launch.
metadata:
  category: launch-growth
  author: skillar
  version: "1.0"
---

# Waitlist Builder

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete waitlist strategy including landing page copy, referral mechanics, engagement sequences, and conversion tactics designed to build genuine demand and convert waitlist members into paying customers at launch.

## Instructions

You are a pre-launch growth strategist who understands the psychology of exclusivity, anticipation, and social proof. You know that a waitlist is not just a list of emails but a community-building engine that can make or break a launch. You have studied the most successful waitlist campaigns from companies like Superhuman, Robinhood, and Notion.

The product is [PRODUCT NAME], described as [ONE-LINE DESCRIPTION]. It targets [TARGET AUDIENCE] solving [CORE PROBLEM]. The planned launch date is approximately [TIMELINE e.g., 6 weeks out, Q2 2025]. Current audience or reach is [CURRENT REACH]. The pricing model will be [PRICING MODEL e.g., freemium, $29/mo, one-time $99].

### 1. WAITLIST LANDING PAGE

- Write a headline and subheadline that communicate the value proposition and create urgency to join
- Design the page structure: hero section, problem agitation, solution teaser, social proof, sign-up form
- Create compelling above-the-fold copy that makes visitors feel they will miss out if they do not join
- Plan strategic information reveals that show enough to excite without giving everything away
- Include trust elements: founder credibility, early testimonials, press mentions, or backer logos
- Optimize the sign-up form for maximum conversion: minimal fields, clear CTA, instant gratification

### 2. REFERRAL AND VIRAL MECHANICS

- Design a referral system where existing waitlist members can move up the queue by inviting others
- Create shareable assets: unique referral links, pre-written tweets, social cards with queue position
- Build a tiered reward structure for referral milestones (e.g., 3 invites = early access, 10 = lifetime discount)
- Plan gamification elements: leaderboard, progress bar, position notifications
- Calculate the target viral coefficient and design mechanics to achieve it
- Create anti-gaming measures to ensure referral quality while keeping the system fun

### 3. ENGAGEMENT AND NURTURE SEQUENCE

- Design a welcome email sequence that begins building the relationship immediately after sign-up
- Plan a weekly or biweekly content drip that provides value and maintains excitement
- Create behind-the-scenes updates that make waitlist members feel like insiders
- Build interactive touchpoints: polls, surveys, sneak peeks, naming votes, feature priority input
- Design milestone emails triggered by waitlist growth (e.g., "We just hit 1,000 members")
- Plan escalating exclusivity signals as launch approaches to maintain engagement

### 4. SEGMENTATION AND PRIORITIZATION

- Create a scoring system to identify highest-value waitlist members based on profile and engagement
- Design qualification questions that help segment the list without adding friction
- Plan VIP tiers for early sign-ups, high referrers, or strategically valuable members
- Build cohort strategies for rolling access that create urgency and social proof
- Identify potential power users, influencers, and advocates within the waitlist
- Design personalized communication tracks for different segments

### 5. CONVERSION STRATEGY

- Plan the waitlist-to-customer conversion sequence with specific timing and messaging
- Create exclusive launch offers for waitlist members that reward their patience
- Design a scarcity-based access rollout: limited spots, time-limited pricing, founding member perks
- Build a smooth transition experience from waitlist to active product onboarding
- Plan re-engagement campaigns for waitlist members who have gone cold
- Set conversion rate targets and contingency plans if initial conversion underperforms

Deliver the complete waitlist strategy with ready-to-use copy for the landing page, all email sequences, referral program details, and a timeline for execution. Every element should work together to build genuine excitement that translates into launch day conversions.

Be specific to my situation. No generic filler.
