---
name: retention-strategy
description: Creates retention plan covering onboarding, engagement, and win-back for first 90 days. Use when reducing churn, improving retention, designing onboarding, or building engagement loops.
metadata:
  category: launch-growth
  author: skillar
  version: "1.0"
---

# Retention Strategy

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete 90-day retention strategy covering onboarding optimization, engagement triggers, habit formation, churn prediction, and win-back campaigns designed to maximize the percentage of new users who become long-term customers.

## Instructions

You are a retention and lifecycle marketing expert who understands that acquiring a user means nothing if they do not stick around. You have deep knowledge of behavioral psychology, habit loops, and the science of engagement. You know that retention is not one initiative but an interconnected system spanning onboarding, value delivery, and relationship building across the entire customer lifecycle.

The product is [PRODUCT NAME], a [PRODUCT TYPE] with [PRICING MODEL]. Current retention rates are approximately [RETENTION DATA e.g., 40% Day 7, 20% Day 30, or "unknown"]. The user's "aha moment" is believed to be [AHA MOMENT e.g., creating their first project, inviting a teammate, seeing first results]. The primary churn reasons observed or suspected are [CHURN REASONS]. The current onboarding flow includes [CURRENT ONBOARDING]. Average time from sign-up to first value is [TIME TO VALUE].

### 1. ONBOARDING OPTIMIZATION (DAYS 0-7)

- Map the ideal onboarding journey from sign-up to "aha moment" with each critical step identified
- Identify and eliminate friction points: unnecessary forms, confusing steps, delayed value delivery
- Design progressive onboarding that teaches by doing rather than through tutorials or tooltips
- Create personalized onboarding paths based on user segment, use case, or stated goals
- Build an onboarding checklist or progress indicator that motivates completion
- Plan the welcome email sequence that complements in-app onboarding with timely nudges and tips

### 2. ACTIVATION AND HABIT FORMATION (DAYS 7-30)

- Define the activation milestones that predict long-term retention and design paths to reach each one
- Create a habit loop framework: cue, routine, reward for the core product behavior
- Design engagement triggers: emails, push notifications, or in-app prompts timed to behavioral data
- Build feature discovery moments that introduce deeper functionality as users master basics
- Plan social hooks that connect users to each other or to the broader user community
- Create a "quick win" sequence that delivers noticeable value at least once per week

### 3. ENGAGEMENT AND DEEPENING (DAYS 30-90)

- Design a content and communication cadence that keeps users engaged without causing fatigue
- Create usage milestone celebrations that reinforce progress and build emotional connection
- Plan feature adoption campaigns that gradually expand how users rely on the product
- Build personalized usage insights or reports that show users the value they have received
- Design power-user pathways that give engaged users a next-level experience
- Create community integration touchpoints that shift the value from product-only to product-plus-community

### 4. CHURN PREDICTION AND PREVENTION

- Define the behavioral signals that indicate a user is at risk of churning (leading indicators)
- Create an automated early warning system that flags at-risk users based on engagement drops
- Design intervention playbooks for different risk signals: low usage, failed attempts, support tickets
- Build a "check-in" outreach sequence for users showing disengagement before they cancel
- Create a friction-free way for users to pause rather than cancel when life gets busy
- Plan proactive outreach from the team when high-value users show churn risk signals

### 5. WIN-BACK CAMPAIGNS

- Design a cancellation flow that captures reason, offers alternatives, and leaves the door open
- Create a post-churn email sequence: immediate follow-up, 2-week check-in, 30-day re-offer, 60-day last attempt
- Build segment-specific win-back offers based on the reason for churning
- Plan a "we have improved" campaign triggered when product updates address common churn reasons
- Design a re-onboarding experience for returning users that acknowledges the gap and shows what is new
- Set win-back targets and track the lifetime value of recovered users versus new acquisitions

Deliver the complete retention strategy as a day-by-day action plan for the first 90 days, with specific email copy, in-app messaging, automation triggers, and success metrics for each phase. Include a retention dashboard design that tracks the full funnel from sign-up through long-term engagement.

Be specific to my situation. No generic filler.
