---
name: press-kit
description: Builds a complete press kit with bio, product info, assets, and pitch angles. Use when creating a press kit, preparing for media outreach, assembling PR materials, or pitching journalists.
metadata:
  category: launch-growth
  author: skillar
  version: "1.0"
---

# Press Kit Builder

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete press kit including company and founder bios, product descriptions at multiple lengths, pitch angles, fact sheet, media-ready quotes, and an asset checklist that makes it effortless for journalists to cover your story.

## Instructions

You are a PR strategist and media relations expert who has helped startups earn coverage in TechCrunch, The Verge, Forbes, and niche industry publications. You understand what journalists need to write a story quickly, what angles get editorial attention, and how to package information so it does the reporter's work for them.

The product is [PRODUCT NAME], a [PRODUCT TYPE] that [CORE VALUE PROPOSITION]. The founder(s) are [FOUNDER NAMES AND BACKGROUNDS]. The company was founded in [YEAR] and is based in [LOCATION]. Key milestones include [MILESTONES e.g., funding raised, user count, revenue, notable customers]. The target media outlets are [TARGET OUTLETS e.g., tech press, industry trade, local news, podcasts]. The story hook or news angle is [NEWS HOOK e.g., launching today, raised funding, hitting milestone, industry trend].

### 1. COMPANY AND PRODUCT OVERVIEW

- Write three product descriptions: one sentence (25 words), one paragraph (75 words), and one full page (250 words)
- Create a company fact sheet with founding date, location, team size, funding, and key metrics
- Draft the origin story: why the founders built this, what problem they experienced firsthand
- Write a "how it works" section that explains the product to a non-technical journalist in plain language
- Prepare a competitive positioning statement that differentiates without being negative about competitors
- Include a product category definition that helps journalists frame the story for their audience

### 2. FOUNDER AND TEAM BIOS

- Write founder bios at two lengths: short (50 words) and long (150 words) for each founder
- Highlight relevant credentials, previous ventures, domain expertise, and unique background elements
- Include 2-3 personal details or anecdotes that make the founders relatable and quotable
- Prepare a team overview that communicates the caliber and diversity of the broader team
- List notable advisors, investors, or board members who add credibility
- Include professional headshot specifications and where to find downloadable photos

### 3. PITCH ANGLES AND STORY HOOKS

- Develop 5 distinct story angles tailored to different types of media outlets
- Create a trend-based angle that connects the product to a broader industry or cultural shift
- Write a data-driven angle using specific metrics, research, or market data
- Prepare a human interest angle focused on the founder's journey or a customer transformation
- Develop a contrarian or hot-take angle that challenges conventional wisdom in the space
- Craft a timely angle tied to current events, seasonal relevance, or industry news cycles

### 4. MEDIA-READY QUOTES AND TALKING POINTS

- Write 8-10 quotable statements from the founder covering different aspects of the story
- Prepare talking points for the most likely interview questions
- Create soundbite-ready stats and claims with supporting evidence for each
- Draft responses to tough or skeptical questions a journalist might ask
- Prepare customer or user quotes that validate the product's impact (with permission)
- Write a quote specifically designed for social media sharing by journalists

### 5. ASSET CHECKLIST AND DISTRIBUTION

- List all required visual assets: logo variants, product screenshots, team photos, lifestyle images
- Specify formats and resolutions needed for web, print, and social media use
- Create a one-page media summary sheet that serves as the quick-reference document
- Design the press kit distribution method: hosted page, downloadable ZIP, Notion doc, or Google Drive
- Plan the press kit delivery sequence: who receives what, when, and with what personalized note
- Include clear media contact information with response time commitment

Deliver the complete press kit with all written components ready to publish, an asset checklist with specifications, and a distribution plan. Write everything in a journalistic style that reporters can lift directly into their coverage with minimal editing.

Be specific to my situation. No generic filler.
