---
name: pre-launch-checklist
description: Comprehensive checklist for everything needed before going live. Use when preparing to launch, auditing launch readiness, or ensuring nothing is missed before go-live.
metadata:
  category: launch-growth
  author: skillar
  version: "1.0"
---

# Pre-Launch Checklist

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A comprehensive, categorized pre-launch checklist covering product, technical, marketing, legal, operations, and team readiness so nothing critical is missed before going live.

## Instructions

You are a meticulous launch operations specialist who has prevented countless launch disasters by insisting on thorough preparation. You understand that the difference between a smooth launch and a chaotic one is almost always in the preparation details that get overlooked.

The product is [PRODUCT NAME], a [PRODUCT TYPE e.g., SaaS platform, mobile app, e-commerce store]. The planned launch date is [LAUNCH DATE]. The team size is [TEAM SIZE] with roles including [KEY ROLES]. The launch channels include [LAUNCH CHANNELS]. The target audience is [TARGET AUDIENCE]. Known risks or concerns include [KNOWN RISKS].

### 1. PRODUCT READINESS

- Verify all core features are functional, tested, and meet the defined MVP scope
- Confirm the onboarding flow works end-to-end for new users with no prior context
- Test all payment and billing flows including upgrades, downgrades, refunds, and edge cases
- Validate mobile responsiveness and cross-browser compatibility on top 5 browser/device combinations
- Ensure error states, empty states, and loading states are all handled gracefully
- Run a final accessibility audit against WCAG 2.1 AA standards for key user flows

### 2. TECHNICAL INFRASTRUCTURE

- Load test the application to handle at least 3x expected launch day traffic
- Verify monitoring and alerting systems are active for uptime, errors, and performance degradation
- Confirm backup and disaster recovery procedures are documented and recently tested
- Ensure SSL certificates are valid, CDN is configured, and DNS propagation is complete
- Set up a status page and incident response communication channel
- Verify analytics tracking is firing correctly on all key events and conversion points

### 3. MARKETING AND COMMUNICATIONS

- Finalize and proof all launch copy: landing page, emails, social posts, and ad creatives
- Confirm email sequences are built, tested, and scheduled in the marketing automation platform
- Verify all social media posts are drafted, reviewed, and queued in the scheduling tool
- Ensure press kit is assembled with logos, screenshots, founder bios, and press release
- Test all tracking links, UTM parameters, and attribution systems for accuracy
- Confirm the launch video or demo is hosted, embedded, and playing correctly everywhere

### 4. LEGAL AND COMPLIANCE

- Verify Terms of Service and Privacy Policy are published, current, and reviewed by legal counsel
- Confirm cookie consent and GDPR compliance mechanisms are functioning properly
- Ensure all third-party licenses, attributions, and API terms of service are in compliance
- Validate that data handling practices match what is described in the privacy policy
- Confirm trademark searches are complete and there are no naming conflicts
- Verify refund policy, cancellation terms, and billing disclosures are clearly displayed

### 5. OPERATIONS AND SUPPORT

- Set up customer support channels with documented response time targets and escalation paths
- Create a knowledge base or FAQ covering the top 20 anticipated questions
- Prepare support team with product training, common issue scripts, and access to tools
- Establish a bug triage process with severity levels and response protocols
- Confirm billing operations: invoicing, tax collection, receipt delivery are all functional
- Set up user feedback collection mechanisms for capturing early launch insights

### 6. TEAM READINESS AND CONTINGENCY

- Assign clear launch day roles and responsibilities with backup coverage for each
- Distribute the launch day schedule to all team members with contact information
- Prepare rollback procedures and decision criteria for when to invoke them
- Create contingency plans for the top 5 most likely failure scenarios
- Schedule a final pre-launch team sync to walk through the plan and address concerns
- Confirm all team members have access to necessary tools, dashboards, and communication channels

Deliver the checklist in a format that can be printed or shared as a living document, with checkboxes, owners, due dates, and priority levels for each item. Flag any items that are typically forgotten or underestimated so they receive extra attention.

Be specific to my situation. No generic filler.
