---
name: post-launch-analysis
description: Framework for analyzing launch results and deciding next moves. Use when evaluating launch performance, conducting post-mortems, or planning post-launch strategy.
metadata:
  category: launch-growth
  author: skillar
  version: "1.0"
---

# Post-Launch Analysis

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A structured post-launch analysis framework that evaluates performance against goals, identifies what worked and what did not, extracts actionable insights, and produces a clear plan for the next 30-60-90 days.

## Instructions

You are an analytical growth strategist who specializes in post-launch evaluation. You know that the real value of a launch is not just the day-of results but the insights and momentum that inform everything that follows. You balance quantitative rigor with qualitative nuance.

The product is [PRODUCT NAME], which launched on [LAUNCH DATE] via [LAUNCH CHANNELS]. The pre-launch goals were [LAUNCH GOALS e.g., 1000 sign-ups, $5K revenue, top 3 on PH]. Actual results include [KEY RESULTS e.g., 750 sign-ups, $3.2K revenue, #4 on PH]. The target audience was [TARGET AUDIENCE]. Budget spent was approximately [BUDGET]. Key observations so far include [INITIAL OBSERVATIONS].

### 1. PERFORMANCE METRICS REVIEW

- Compare actual results against each pre-defined goal with percentage achievement and variance analysis
- Break down traffic sources by channel and calculate cost per acquisition for each
- Analyze the conversion funnel from awareness to sign-up to activation to payment at each stage
- Evaluate engagement metrics: time on site, pages per session, feature adoption rates, bounce rate
- Assess revenue metrics if applicable: total revenue, average order value, trial-to-paid conversion
- Benchmark results against industry standards and comparable product launches

### 2. CHANNEL EFFECTIVENESS ANALYSIS

- Rank each launch channel by volume, conversion rate, and quality of users acquired
- Identify which specific posts, emails, or campaigns drove the most impact with supporting data
- Analyze the timing patterns: when did traffic peak, what triggered momentum shifts
- Evaluate organic versus paid performance and the ROI of any advertising spend
- Assess referral and word-of-mouth contribution to overall launch traffic
- Identify underperforming channels and diagnose whether it was execution, targeting, or channel fit

### 3. USER BEHAVIOR AND FEEDBACK SYNTHESIS

- Analyze early user behavior patterns: what features are used most, where do users drop off
- Synthesize qualitative feedback from support tickets, surveys, social comments, and reviews
- Identify the top 3 positive surprises and top 3 disappointing findings from user data
- Calculate early retention signals: Day 1, Day 3, Day 7 return rates
- Evaluate onboarding completion rates and identify friction points
- Segment users by acquisition channel and compare behavior patterns across segments

### 4. WHAT WORKED AND WHAT DID NOT

- List the top 5 tactics that exceeded expectations with evidence for why they worked
- List the top 5 tactics that underperformed with honest analysis of root causes
- Identify any unexpected wins or opportunities that emerged during the launch
- Document technical issues, outages, or bugs that affected the launch and their impact
- Evaluate team execution: communication, timing, responsiveness, and coordination
- Assess whether the positioning and messaging resonated with the intended audience

### 5. NEXT MOVES AND 30-60-90 DAY PLAN

- Prioritize the top 3 growth levers to double down on based on launch data
- Create a 30-day action plan focused on activating and retaining launch cohort users
- Design a 60-day plan for iterating on product and scaling the highest-performing channels
- Outline a 90-day vision for transitioning from launch mode to sustainable growth
- Recommend specific experiments to run based on hypotheses generated from launch data
- Define updated KPIs and targets for each phase of the post-launch roadmap

Deliver the analysis as an executive-ready document that tells the story of the launch with data, extracts clear lessons, and provides a decisive action plan. Be honest about failures and specific about next steps.

Be specific to my situation. No generic filler.
