---
name: partnership-outreach
description: Creates partnership outreach templates and strategy for co-marketing. Use when reaching out to partners, planning co-marketing campaigns, building strategic alliances, or creating integration partnerships.
metadata:
  category: launch-growth
  author: skillar
  version: "1.0"
---

# Partnership Outreach Strategy

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete partnership outreach strategy including partner identification framework, outreach templates, co-marketing proposals, and relationship management plan to create mutually beneficial growth partnerships.

## Instructions

You are a in strategic partnerships and business development who has brokered deals between startups, established brands, and creators. You understand that the best partnerships are rooted in genuine mutual value, not one-sided asks. You know how to craft outreach that gets responses and proposals that get approved.

The product is [PRODUCT NAME], a [PRODUCT TYPE] serving [TARGET AUDIENCE]. The partnership goals are [GOALS e.g., reach new audiences, add integrations, co-create content, cross-sell]. The current stage is [STAGE e.g., pre-launch, 500 users, $10K MRR]. Existing partnerships or relationships include [EXISTING RELATIONSHIPS]. The ideal partner profile is [IDEAL PARTNER e.g., complementary SaaS tools, industry influencers, media outlets, agencies]. Resources available for partnership activities include [RESOURCES].

### 1. PARTNER IDENTIFICATION AND PRIORITIZATION

- Define the ideal partner profile across 3-4 partnership types: integration, co-marketing, distribution, content
- Create a scoring matrix evaluating potential partners on audience overlap, brand alignment, and reach
- Build a target list of 20-30 potential partners organized by tier: dream, strong fit, and easy win
- Research each target partner's current partnership activity and what they value in collaborations
- Identify warm introduction paths through mutual connections, communities, or events
- Map the decision-maker at each target organization and their preferred communication channels

### 2. OUTREACH MESSAGING

- Write a cold outreach email template that leads with value to the partner, not your ask
- Create a warm introduction request template for mutual connections to use
- Draft a LinkedIn connection and message sequence for cold outreach on social platforms
- Write a follow-up sequence: 3-touch cadence with different angles and escalating specificity
- Create personalization frameworks showing how to customize each template for specific partners
- Design a "quick win" proposal that requires minimal commitment to start the relationship

### 3. PARTNERSHIP PROPOSALS

- Build a one-page co-marketing partnership proposal template with clear mutual benefits
- Create an integration partnership brief outlining technical scope, timeline, and shared promotion plan
- Design a content collaboration proposal: webinars, guest posts, co-created resources, podcast swaps
- Draft a distribution partnership proposal for bundle deals, marketplace listings, or reseller arrangements
- Include specific metrics and projections each partner can expect from the collaboration
- Prepare objection responses for common partnership concerns: bandwidth, brand risk, low ROI

### 4. CO-MARKETING EXECUTION

- Design 5 co-marketing campaign templates: joint webinar, content swap, shared giveaway, integration launch, case study
- Create a co-marketing brief template that aligns both teams on goals, timelines, and deliverables
- Plan the asset creation workflow: who creates what, review process, approval timeline
- Build a shared promotion calendar ensuring both partners amplify the collaboration equally
- Design cross-promotion templates for email, social, and in-app placement
- Create measurement frameworks for tracking the impact of each co-marketing activity

### 5. RELATIONSHIP MANAGEMENT

- Design a partnership CRM workflow to track outreach, responses, deals, and ongoing activities
- Create a partnership onboarding checklist for new partners covering logistics and expectations
- Plan a quarterly partner review cadence to assess performance and plan future activities
- Build a partner communication template for monthly updates and opportunity sharing
- Design escalation and conflict resolution protocols for partnership disagreements
- Create a partner appreciation program: shoutouts, referrals, exclusive access, event invitations

Deliver the complete partnership strategy with ready-to-send outreach templates, proposal documents, co-marketing playbooks, and a management system. Every template should be specific enough to use immediately while flexible enough to customize for different partner types.

Be specific to my situation. No generic filler.
