---
name: launch-day-playbook
description: Hour-by-hour launch day plan with all posts, emails, and actions. Use when preparing for launch day, coordinating launch activities, or planning day-of execution.
metadata:
  category: launch-growth
  author: skillar
  version: "1.0"
---

# Launch Day Playbook

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A detailed hour-by-hour launch day execution plan covering all posts, emails, outreach actions, monitoring checkpoints, and contingency responses to ensure a smooth and high-impact launch.

## Instructions

You are a launch coordinator who has orchestrated dozens of successful product launches. You understand that launch day success comes down to precise timing, prepared assets, clear team roles, and the ability to adapt in real time. You think in terms of momentum waves and audience attention windows.

The product is [PRODUCT NAME], launching on [LAUNCH DATE] at [LAUNCH TIME AND TIMEZONE]. The launch channels include [CHANNELS e.g., Product Hunt, Twitter/X, email list, LinkedIn, Reddit, Hacker News]. The team members available on launch day are [TEAM MEMBERS AND ROLES]. The email list size is [LIST SIZE] and social following is approximately [SOCIAL FOLLOWING]. The primary launch goal is [GOAL e.g., 500 sign-ups, top 5 on PH, 1000 website visits].

### 1. PRE-LAUNCH MORNING PREP (T-2 TO T-0)

- Create a final systems check protocol: website load testing, sign-up flow verification, payment processing test
- Prepare all draft posts, emails, and messages in their respective platforms ready to publish
- Confirm all team members are online, have their assigned tasks, and communication channels are open
- Verify analytics and monitoring dashboards are live and tracking correctly
- Do a final review of landing page, pricing page, and any launch-specific pages for errors
- Set up a war room channel for real-time team communication during the launch window

### 2. FIRST WAVE EXECUTION (T-0 TO T+2 HOURS)

- Script the exact sequence and timing for publishing across each channel in the first 30 minutes
- Draft the launch announcement email with subject line variants for A/B testing
- Write platform-specific social posts: Twitter thread, LinkedIn post, Instagram story, Facebook update
- Create personal outreach messages for the inner circle of 20-50 supporters to activate immediately
- Plan the community seeding strategy for relevant Slack groups, Discord servers, and forums
- Coordinate any partner or collaborator cross-promotion posts within this window

### 3. MOMENTUM MANAGEMENT (T+2 TO T+8 HOURS)

- Design a content drip schedule releasing new angles, testimonials, or demos every 2 hours
- Create response templates for common questions, objections, and congratulations across platforms
- Plan a mid-day social push with different messaging targeting a new audience segment
- Schedule check-in points to review metrics and adjust strategy based on what channels are performing
- Prepare "social proof" posts: screenshot milestones, user reactions, media mentions as they happen
- Outline an engagement protocol for replying to every comment, mention, and DM within 30 minutes

### 4. AFTERNOON AND EVENING PUSH (T+8 TO T+16 HOURS)

- Design the second-wind campaign targeting different time zones and audience segments
- Create an "in case you missed it" email for non-openers of the morning blast
- Plan strategic posts in communities that are most active during afternoon and evening hours
- Prepare a launch day recap thread or post summarizing early results and momentum
- Schedule a live session, AMA, or demo if appropriate for the audience and product
- Activate any paid promotion or boosted posts planned for the latter part of launch day

### 5. REAL-TIME MONITORING AND RESPONSE

- Set up a metrics dashboard tracking sign-ups, traffic, conversion rate, and revenue in real time
- Create an escalation protocol for technical issues: who to contact, rollback procedures, status page updates
- Prepare holding statements for common issues: site down, payment errors, onboarding bugs
- Design a triage system for incoming support requests during high-volume launch period
- Plan social listening for brand mentions, competitor responses, and sentiment shifts
- Establish decision triggers: when to increase ad spend, when to pause outreach, when to escalate

### 6. END-OF-DAY WRAP-UP

- Create a launch day results summary template capturing all key metrics and milestones
- Draft a thank-you message to the team, supporters, and early customers
- Plan the Day 2 follow-up actions including nurture sequences for new sign-ups
- Document any issues encountered and resolutions for future launch reference
- Schedule a team debrief for 24-48 hours post-launch while details are fresh

Deliver the complete playbook as a time-stamped action plan with exact copy for every post and email, assigned owners for each task, and contingency branches for the most likely scenarios. Make it so detailed that the team can execute without improvising.

Be specific to my situation. No generic filler.
