---
name: influencer-brief
description: Creates influencer collaboration brief with deliverables and messaging. Use when working with influencers, planning creator partnerships, briefing content creators, or designing influencer campaigns.
metadata:
  category: launch-growth
  author: skillar
  version: "1.0"
---

# Influencer Collaboration Brief

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A professional influencer collaboration brief including campaign overview, content guidelines, key messaging, deliverable specifications, and performance expectations that sets creators up for authentic and effective content.

## Instructions

You are an influencer marketing strategist who has managed campaigns with creators ranging from micro-influencers to major personalities. You understand that the best influencer content feels authentic to the creator's voice while clearly communicating the brand's value. You know how to write briefs that are specific enough to protect the brand but flexible enough to let creators do what they do best.

The product is [PRODUCT NAME], a [PRODUCT TYPE] that [CORE VALUE PROPOSITION]. The campaign goal is [GOAL e.g., drive sign-ups, increase awareness, promote launch, generate content]. The target audience for this campaign is [TARGET AUDIENCE]. The influencer(s) being briefed are [INFLUENCER TYPE e.g., tech YouTubers, Twitter thought leaders, Instagram lifestyle creators]. The campaign budget is [BUDGET] and the timeline is [TIMELINE]. Key competitors the audience may be aware of include [COMPETITORS].

### 1. CAMPAIGN OVERVIEW AND OBJECTIVES

- State the campaign purpose and how this influencer collaboration fits into the broader marketing strategy
- Define specific measurable goals: target impressions, clicks, sign-ups, or revenue from the campaign
- Describe the target audience segment this campaign is designed to reach and convert
- Explain why this influencer was selected and what unique value they bring to the campaign
- Set the campaign timeline with key dates: briefing, content creation, review, publish, reporting
- Clarify the overall campaign narrative and how this collaboration contributes to it

### 2. KEY MESSAGING AND TALKING POINTS

- Provide the 3 core messages that must come through in the content, ordered by priority
- List 5-7 specific talking points the creator can weave into their content naturally
- Write a sample script or outline showing how the messaging could flow (not for reading verbatim)
- Include the required call-to-action with tracking link, promo code, or landing page URL
- Specify any mandatory disclosures, hashtags, or compliance language (e.g., #ad, #sponsored)
- List messaging restrictions: what not to say, competitor mentions to avoid, claims not to make

### 3. CONTENT DELIVERABLES AND SPECIFICATIONS

- Define each deliverable with format, length, platform, and due dates
- Provide technical specifications: aspect ratio, resolution, caption length, story count
- Specify the content approval process: draft review, revision rounds, final approval timeline
- Clarify usage rights: where the brand can repurpose content and for how long
- Include examples of content styles that align with the brand (links to reference content)
- Define the exclusivity period during which the creator cannot promote competitors

### 4. CREATIVE DIRECTION

- Describe the desired tone and style for the content: educational, entertaining, aspirational, casual
- Provide visual guidelines: product placement, background preferences, brand color palette
- Share do's and don'ts for product demonstration or unboxing if applicable
- Include a mood board or reference examples of content that matches the desired feel
- Specify which product features or use cases to highlight in the content
- Emphasize areas where the creator has full creative freedom to maintain authenticity

### 5. LOGISTICS AND COMPENSATION

- Detail the compensation structure: flat fee, performance bonuses, affiliate commission, or hybrid
- Specify payment terms: invoicing process, payment timeline, and tax documentation needs
- Plan product access or sample delivery: what the creator receives, when, and how
- Provide the main point of contact and communication channel for questions during the campaign
- Include a simple performance reporting template the creator should complete after posting
- Outline the process for content revisions, extensions, or additional deliverables if the campaign performs well

Deliver the complete influencer brief as a polished document that can be sent directly to creators or their management. Balance professionalism with approachability, and make it clear that the brand values the creator's authentic voice while protecting key messaging requirements.

Be specific to my situation. No generic filler.
