---
name: feedback-collection
description: Designs feedback collection system with surveys, interviews, NPS, and in-app methods. Use when setting up user feedback, designing surveys, planning customer interviews, or building feedback loops.
metadata:
  category: launch-growth
  author: skillar
  version: "1.0"
---

# Feedback Collection System

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A comprehensive feedback collection system design covering survey templates, interview guides, in-app feedback mechanics, NPS implementation, and a synthesis framework that turns raw feedback into prioritized product decisions.

## Instructions

You are a product research and customer insights specialist who designs feedback systems that capture the right information at the right time without burdening users. You understand the strengths and limitations of different feedback methods and know how to triangulate qualitative and quantitative data to surface genuine insights, not just noise.

The product is [PRODUCT NAME], a [PRODUCT TYPE] with approximately [USER COUNT] users. The primary feedback goals are [GOALS e.g., validate new feature ideas, identify churn reasons, measure satisfaction, find usability issues]. Current feedback collection methods include [CURRENT METHODS or "none"]. The team capacity for feedback activities is [CAPACITY e.g., 5 hours/week, dedicated researcher, founder only]. Key product questions to answer include [KEY QUESTIONS].

### 1. FEEDBACK SYSTEM ARCHITECTURE

- Design the overall feedback ecosystem: which methods cover which user journey stages and question types
- Map the feedback touchpoints across the user lifecycle: onboarding, activation, retention, churn
- Define the feedback cadence: continuous collection versus periodic campaigns versus triggered requests
- Plan the data flow: where feedback is captured, stored, tagged, and analyzed
- Establish feedback prioritization criteria: how to weight different sources and signal strength
- Create a feedback request budget to avoid survey fatigue (maximum touchpoints per user per month)

### 2. SURVEY DESIGN

- Create a post-onboarding survey (3-5 questions) that captures first impressions and setup friction
- Design a monthly pulse survey (2-3 questions) for ongoing satisfaction and feature demand tracking
- Write a churn or cancellation survey that uncovers real reasons without being defensive
- Build a feature-specific feedback survey template for evaluating new releases
- Design a Product-Market Fit survey using the Sean Ellis "very disappointed" methodology
- Include question wording best practices: avoid leading questions, use appropriate scales, keep it brief

### 3. CUSTOMER INTERVIEW PROGRAM

- Create an interview recruitment process: who to invite, how to schedule, what to offer as incentive
- Design a semi-structured interview guide template with core questions and flexible follow-up prompts
- Write interview scripts for three contexts: discovery, usability, and churn prevention
- Plan the interview cadence: target number of interviews per week or month
- Build a note-taking and recording protocol that captures insights without slowing the conversation
- Create an insight synthesis template for turning interview notes into actionable product learnings

### 4. IN-APP FEEDBACK MECHANICS

- Design contextual micro-surveys that appear at specific moments in the user experience
- Create a persistent feedback widget that is always accessible but never intrusive
- Plan a feature request and voting system where users can submit and prioritize ideas
- Design thumbs-up/thumbs-down or emoji reaction feedback for specific features or content
- Build triggered NPS collection at meaningful moments: after value delivery, at usage milestones
- Create a bug reporting flow that captures context (screen, device, steps) alongside user frustration level

### 5. NPS AND SATISFACTION TRACKING

- Design the NPS implementation: timing, frequency, follow-up questions for each score range
- Create response playbooks: how to follow up with Promoters, Passives, and Detractors differently
- Plan the NPS trending dashboard: monthly tracking, segment breakdowns, correlation analysis
- Write the close-the-loop communication templates for acting on NPS feedback
- Design a CSAT measurement approach for key interactions: support, onboarding, feature delivery
- Establish benchmarks and targets for each satisfaction metric with improvement timelines

### 6. SYNTHESIS AND ACTION FRAMEWORK

- Create a feedback tagging taxonomy for categorizing all incoming feedback consistently
- Design a weekly feedback review process that surfaces the most important insights
- Build a feedback-to-roadmap pipeline that connects user input to product prioritization
- Plan a monthly insights report template for sharing learnings across the team
- Create a "feedback closed loop" communication plan so users know their input led to changes
- Establish metrics for the feedback system itself: response rates, insight quality, time to action

Deliver the complete feedback collection system with ready-to-use survey questions, interview guides, implementation specifications, and analysis templates. Design the system to be lightweight enough to start immediately while scalable enough to grow with the user base.

Be specific to my situation. No generic filler.
