---
name: early-adopter-program
description: Creates an early adopter or founding member program with incentives. Use when designing founding member tiers, early adopter rewards, VIP access programs, or loyalty incentives for first users.
metadata:
  category: launch-growth
  author: skillar
  version: "1.0"
---

# Early Adopter Program

*Because your first 100 users will make or break everything that comes after.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete early adopter or founding member program design including tier structure, incentive packages, engagement framework, and communication plan that turns first users into passionate advocates.

## Instructions

You are a in community-driven product growth who specializes in designing programs that transform early users into lifelong champions. You understand the psychology of belonging, exclusivity, and co-creation that drives the strongest early adopter relationships. You know how to balance giving value to early adopters while building sustainable business economics.

The product is [PRODUCT NAME], a [PRODUCT TYPE]. It targets [TARGET AUDIENCE] and the standard pricing will be [STANDARD PRICING]. The number of early adopter spots available is [SPOTS e.g., 100, 500]. The product is currently at [STAGE e.g., beta, pre-launch, just launched]. The key value proposition for early adopters beyond pricing is [UNIQUE VALUE e.g., shape the roadmap, exclusive community, direct founder access].

### 1. PROGRAM STRUCTURE AND TIERS

- Design 2-3 founding member tiers with distinct names that evoke exclusivity and status
- Define the specific benefits, access levels, and pricing for each tier
- Set clear capacity limits for each tier that create genuine scarcity
- Establish the program timeline: enrollment window, benefit duration, and any expiration terms
- Define what founding members receive that will never be available to later customers
- Create a clear value comparison showing founding member benefits versus standard pricing

### 2. INCENTIVE DESIGN

- Build a financial incentive package: lifetime discounts, locked-in pricing, credit bonuses, or free months
- Design access-based incentives: early feature access, priority support, dedicated onboarding
- Create status-based incentives: founding member badge, public recognition, community roles
- Plan influence-based incentives: roadmap voting rights, direct feedback channel, advisory board seat
- Include surprise and delight elements: unexpected perks, anniversary gifts, milestone rewards
- Ensure incentives are generous enough to excite but sustainable enough to honor long-term

### 3. ENROLLMENT AND ONBOARDING

- Design the enrollment flow: application, invite-only, first-come-first-served, or qualification-based
- Write compelling enrollment page copy that communicates urgency and exclusive value
- Create an onboarding experience specific to founding members that makes them feel special from day one
- Plan a welcome package: personal founder message, exclusive content, community access, quick-start guide
- Set up a dedicated communication channel for founding members (e.g., private Slack, Discord, or forum)
- Define activation milestones that ensure founding members experience core value quickly

### 4. ENGAGEMENT AND COMMUNITY

- Design a recurring engagement cadence: weekly updates, monthly calls, quarterly roadmap reviews
- Plan co-creation opportunities where founding members contribute to product decisions
- Create exclusive content or events available only to program members
- Build a recognition system that celebrates founding member contributions and milestones
- Establish peer connection opportunities so founding members build relationships with each other
- Design a feedback loop where founding member input visibly influences the product

### 5. ADVOCACY AND GROWTH

- Create tools and templates for founding members to share their experience and recruit others
- Design a referral bonus structure specific to the founding member program
- Plan case study or testimonial collection from founding members for marketing use
- Build an ambassador track for founding members who want to actively evangelize the product
- Establish social proof mechanisms that showcase the founding member community externally
- Track and reward founding members whose advocacy drives measurable growth

### 6. PROGRAM COMMUNICATIONS

- Draft the launch announcement for the founding member program across all channels
- Create an email sequence for program invitations with escalating urgency as spots fill
- Write ongoing program update templates: monthly digest, feature previews, community highlights
- Plan milestone communications: enrollment closing soon, new benefits added, program anniversary
- Design a graceful program closure communication for when all spots are filled

Deliver the complete program design with specific tier details, pricing, copy for all communications, and a timeline for rollout. Make the program so compelling that the target audience feels it would be a mistake not to join.

Be specific to my situation. No generic filler.
