---
name: community-building
description: Plans community strategy with platform, content cadence, and engagement tactics. Use when building a community, launching a Discord or forum, planning community content, or increasing user engagement.
metadata:
  category: launch-growth
  author: skillar
  version: "1.0"
---

# Community Building Strategy

*Because a community is not an audience. One talks back.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A comprehensive community strategy covering platform selection, structure design, content cadence, engagement programs, moderation framework, and growth plan to build an active and valuable community around your product.

## Instructions

You are a community builder who has grown thriving communities from zero to thousands of engaged members. You understand that great communities are not built on software but on shared identity, valuable interactions, and a sense of belonging. You know the difference between a community and an audience, and you design for genuine connection over vanity metrics.

The product is [PRODUCT NAME], a [PRODUCT TYPE] for [TARGET AUDIENCE]. The community goal is [GOAL e.g., user support, product feedback, brand loyalty, thought leadership]. The current community status is [STATUS e.g., starting from scratch, 50 members in Slack, active Twitter following]. The team capacity for community management is [CAPACITY e.g., 1 part-time community manager, founder doing it personally]. The budget for community tools and programs is [BUDGET].

### 1. PLATFORM AND STRUCTURE

- Evaluate platform options (Discord, Slack, Circle, forum, Reddit, etc.) against the audience and goals
- Recommend a primary platform with clear rationale and a secondary platform if warranted
- Design the channel or category structure that organizes conversations without overwhelming members
- Plan the permission and role hierarchy: new members, verified members, contributors, moderators, admins
- Set up integration points between the community platform and the product itself
- Create the community landing page or join flow that communicates the value of membership

### 2. LAUNCH AND SEEDING

- Plan the founding member recruitment strategy to get the first 50 engaged members
- Design the community launch announcement across existing channels
- Create seed content for every channel so new members do not arrive to empty rooms
- Recruit and brief 5-10 community champions who will model the desired behavior
- Plan the first 2 weeks of daily activities that establish norms and momentum
- Set up a personal welcome system for every new member during the early growth phase

### 3. CONTENT AND PROGRAMMING

- Design a weekly content calendar with recurring themes and event types
- Plan signature community events: AMAs, workshops, challenges, show-and-tell, office hours
- Create content pillars that align with member interests and product value propositions
- Design user-generated content prompts that encourage members to share their own work
- Plan educational content series that positions the community as a learning destination
- Build a content repurposing workflow that turns community discussions into blog posts and social content

### 4. ENGAGEMENT AND RETENTION

- Design the new member onboarding journey from join to first meaningful interaction
- Create gamification elements: points, badges, levels, leaderboards, or recognition programs
- Plan proactive engagement tactics: direct outreach to lurkers, re-engagement campaigns, activity triggers
- Build a member spotlight or success story program that celebrates community members
- Design feedback loops where community input visibly influences the product roadmap
- Create exclusive benefits for active community members that reinforce participation

### 5. MODERATION AND CULTURE

- Write community guidelines that define the culture in positive terms, not just prohibitions
- Design the moderation workflow: tools, escalation paths, response time targets
- Plan for common community challenges: spam, conflict, toxicity, off-topic drift
- Create moderation team training materials and decision frameworks for edge cases
- Build a reporting system that makes it easy for members to flag issues
- Establish regular culture health checks: sentiment surveys, engagement audits, exit interviews

### 6. GROWTH AND MEASUREMENT

- Define community health metrics: active members, engagement rate, response time, retention, NPS
- Set up a community analytics dashboard tracking weekly and monthly trends
- Plan growth tactics: partnerships, guest experts, cross-promotion, content marketing, referrals
- Design a community-to-product flywheel where community growth drives product growth and vice versa
- Create a quarterly community review process for evaluating strategy and adjusting course
- Plan the scaling strategy: when to hire dedicated community staff, add platforms, or segment the community

Deliver the complete community strategy as an actionable playbook with specific templates, schedules, copy examples, and metrics. Make it practical enough for a solo founder to execute while designing for scale.

Be specific to my situation. No generic filler.
