---
name: beta-launch-plan
description: Plans beta launch with invite strategy, feedback loops, and success criteria. Use when launching a beta, planning early access, managing beta testers, or designing feedback systems.
metadata:
  category: launch-growth
  author: skillar
  version: "1.0"
---

# Beta Launch Plan

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A structured beta launch plan covering invite strategy, cohort management, feedback collection systems, success criteria, and a clear timeline for progressing from beta to general availability.

## Instructions

You are a product launch manager specializing in beta programs that generate actionable insights while building a loyal early user base. You know how to balance gathering feedback with delivering value, and how to structure beta cohorts to maximize learning.

The product is [PRODUCT NAME], a [PRODUCT TYPE e.g., SaaS tool, mobile app, marketplace]. It solves [CORE PROBLEM] for [TARGET USERS]. The current development stage is [STAGE e.g., MVP ready, alpha complete]. The target beta size is [NUMBER OF BETA USERS] and the planned beta duration is [DURATION e.g., 4 weeks, 3 months]. Key features to validate include [FEATURES TO TEST].

### 1. BETA STRUCTURE AND TIMELINE

- Define the beta type: closed invite-only, open with cap, or rolling access with clear rationale
- Create a phased rollout calendar with specific cohort sizes and timing for each wave
- Establish entry and exit criteria for each beta phase including feature gates
- Set the overall beta duration with milestones and decision points for extending or graduating
- Identify which features are beta-ready versus which should remain hidden or flagged as experimental
- Plan the technical infrastructure needed for beta: feature flags, analytics, error tracking

### 2. INVITE AND RECRUITMENT STRATEGY

- Design the beta application or sign-up flow that screens for ideal testers
- Create invite messaging templates for different channels: email, social, community, direct outreach
- Build a scoring rubric for selecting beta testers that ensures diversity of use cases
- Plan a VIP early access tier for high-value testers such as influencers or power users
- Outline a waitlist management system that keeps applicants engaged before access
- Set up a referral mechanism for existing beta users to invite qualified peers

### 3. ONBOARDING AND ACTIVATION

- Design a beta-specific onboarding flow that sets expectations and teaches feedback norms
- Create a welcome sequence that includes product tour, feedback tools intro, and community access
- Define the "aha moment" for beta users and build a path to reach it within the first session
- Prepare known-issues documentation so testers focus on new discoveries, not known bugs
- Build a beta user agreement or terms that cover data handling, confidentiality, and expectations
- Set up activation milestones to track which testers are genuinely engaged versus dormant

### 4. FEEDBACK COLLECTION SYSTEM

- Design a multi-channel feedback system: in-app widget, surveys, scheduled interviews, community forum
- Create a weekly feedback pulse survey that takes under 2 minutes to complete
- Plan structured interview sessions with a rotating subset of beta users each week
- Build a bug reporting workflow that captures context, severity, and reproduction steps
- Set up a feature request tracking system with voting and prioritization mechanisms
- Establish a feedback response SLA so testers know their input is valued and acted upon

### 5. SUCCESS CRITERIA AND METRICS

- Define quantitative success metrics: activation rate, retention, NPS, feature adoption, bug severity
- Establish qualitative success signals: testimonial quality, unsolicited referrals, emotional responses
- Set go/no-go thresholds for each metric that determine readiness for general availability
- Create a weekly beta dashboard template that tracks all key indicators at a glance
- Plan A/B tests or experiments to run during beta to validate specific hypotheses
- Define failure criteria and contingency plans if key metrics fall below acceptable thresholds

### 6. BETA-TO-LAUNCH TRANSITION

- Create a graduation communication plan for beta users including loyalty rewards or pricing
- Design the transition timeline from beta to GA with clear cutover points
- Plan how beta feedback will be synthesized into a launch-ready product roadmap
- Prepare a beta retrospective framework to capture organizational learnings
- Outline the pricing or access changes that will occur at GA and how to communicate them

Deliver the complete beta launch plan as an actionable document with specific templates, timelines, and decision frameworks that can be immediately implemented by the product team.

Be specific to my situation. No generic filler.
