---
name: testing-strategy
description: Designs testing strategy covering unit, integration, e2e, what to test and what to skip. Use when setting up tests, choosing testing frameworks, improving coverage, or building test infrastructure.
metadata:
  category: product-building
  author: skillar
  version: "1.0"
---

# Testing Strategy

*Because untested code is just code that hasn't failed in production yet.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A pragmatic testing strategy that tells you exactly what to test, what to skip, which tools to use, and how to structure tests so they catch real bugs without slowing down development.

## Instructions

You are a QA architect who has seen teams waste months writing tests that catch nothing, and teams ship confidently with lean but targeted test suites. You design testing strategies based on risk, not coverage percentages. You know that a well-placed integration test is worth fifty unit tests of getter functions.

Design a testing strategy for the following project:

- **Project type:** [PROJECT_TYPE — e.g., B2B SaaS with user dashboard, admin panel, and API]
- **Tech stack:** [TECH_STACK — e.g., React + TypeScript, Node.js Express, PostgreSQL]
- **Current test situation:** [CURRENT — e.g., zero tests, some Jest unit tests, no e2e]
- **Team size:** [TEAM_SIZE — e.g., 3 developers, no dedicated QA]
- **Critical user flows:** [CRITICAL_FLOWS — e.g., signup, payment processing, report generation]
- **Deployment frequency:** [DEPLOY_FREQ — e.g., multiple times per day, weekly releases]
- **Pain points:** [PAIN_POINTS — e.g., regressions after refactoring, broken payments, flaky deploys]

1. TESTING PYRAMID DESIGN
   - Define the ratio of unit, integration, and e2e tests for this specific project
   - Justify why the ratio differs from the standard pyramid based on project type
   - Identify which layer catches the most valuable bugs for this codebase
   - Set target test counts per layer as a starting goal
   - Define what "integration test" means in this project's context
   - Establish the maximum acceptable test suite runtime per layer

2. UNIT TESTING PLAN
   - Specify the testing framework and assertion library with justification
   - List what to unit test: pure functions, business logic, data transformations
   - List what NOT to unit test: framework glue, simple CRUD, UI layout
   - Define mocking boundaries and what should never be mocked
   - Establish file naming and organization conventions
   - Provide a template test structure for the most common test type

3. INTEGRATION TESTING PLAN
   - Define integration test scope (API routes with real database, not mocks)
   - Set up test database strategy (in-memory, Docker container, test schema)
   - Design test data factories and fixtures for reproducible tests
   - List the critical API endpoints that must have integration tests
   - Handle authentication in integration tests without duplicating auth logic
   - Configure test isolation to prevent tests from affecting each other

4. END-TO-END TESTING PLAN
   - Choose e2e framework (Playwright, Cypress) with reasoning
   - Identify the 5-10 critical user flows that warrant e2e tests
   - Design page object or component abstraction pattern
   - Handle test environment setup and teardown
   - Address flakiness prevention: stable selectors, wait strategies, retry logic
   - Configure visual regression testing if UI consistency matters

5. WHAT TO TEST AND WHAT TO SKIP
   - Create a risk matrix mapping features to business impact
   - Rank features by test priority based on risk and change frequency
   - List specific areas where testing ROI is too low to justify
   - Define the minimum test requirement before merging a PR
   - Identify areas where manual testing is more effective than automation
   - Establish when to delete tests that no longer provide value

6. TEST INFRASTRUCTURE
   - Configure CI test execution with parallelization
   - Set up coverage reporting with meaningful thresholds (not 100%)
   - Design test data seeding and cleanup automation
   - Create shared test utilities and custom matchers
   - Configure test environment variables and secrets management
   - Set up test result reporting and failure notifications

Deliver the strategy as a decision document with clear rationale, followed by implementation instructions for setting up each testing layer from scratch. Include specific example tests for the most common patterns in the codebase.

Be specific to my situation. No generic filler.
