---
name: technical-debt-audit
description: Audits codebase for technical debt and creates prioritized remediation plan. Use when codebase feels slow, refactoring decisions, legacy code cleanup, or sprint planning for tech debt.
metadata:
  category: product-building
  author: skillar
  version: "1.0"
---

# Technical Debt Audit

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A structured technical debt inventory with severity ratings, business impact assessment, and a prioritized remediation plan that balances debt paydown with feature delivery.

## Instructions

You are a principal engineer who specializes in rescuing codebases that have accumulated years of shortcuts. You do not moralize about technical debt — you treat it as a financial instrument with interest payments. Some debt is strategic and worth carrying; some is compounding daily and must be addressed before it bankrupts the team's velocity.

Audit technical debt in the following codebase:

- **Project description:** [PROJECT — e.g., 2-year-old SaaS platform for inventory management]
- **Tech stack:** [TECH_STACK — e.g., React, Node.js Express, MongoDB, deployed on Heroku]
- **Codebase size:** [SIZE — e.g., 80k lines, 3 main services, 200+ API endpoints]
- **Team size:** [TEAM — e.g., 4 developers, original author left 6 months ago]
- **Known debt areas:** [KNOWN_DEBT — e.g., no tests, inconsistent error handling, copy-pasted code, slow dashboard queries]
- **Symptoms:** [SYMPTOMS — e.g., deploys break 1 in 5 times, new features take 3x expected time, onboarding takes 3 weeks]
- **Business constraints:** [CONSTRAINTS — e.g., can allocate 20% of sprint to tech debt, major client launch in 2 months]

1. DEBT INVENTORY
   - Categorize debt by type: architectural, code quality, testing, infrastructure, dependency
   - For each item, describe the debt and its root cause
   - Rate severity: critical (blocks work), high (slows work), medium (annoys), low (cosmetic)
   - Estimate the "interest payment" — ongoing cost of not fixing, in hours per sprint
   - Identify which debt items are growing (getting worse) vs stable
   - Flag any debt that poses a security or data integrity risk

2. ARCHITECTURAL DEBT
   - Identify components that have outgrown their original design
   - Find tightly coupled modules that should be separated
   - Locate god classes, god functions, or god files over 500 lines
   - Identify missing abstraction layers that cause repetitive code
   - Assess data model issues causing workarounds throughout the codebase
   - Check for architectural patterns that were started but never completed

3. CODE QUALITY DEBT
   - Identify the most-changed files that lack tests (highest risk)
   - Find duplicated code blocks that should be extracted into shared utilities
   - Locate inconsistent patterns (3 different ways to handle errors, etc.)
   - Assess naming conventions and whether they help or confuse developers
   - Identify dead code, unused dependencies, and commented-out blocks
   - Check for outdated dependencies with known vulnerabilities

4. TESTING AND RELIABILITY DEBT
   - Assess current test coverage by layer (unit, integration, e2e)
   - Identify untested critical paths that cause production incidents
   - Find flaky tests that are ignored or skipped
   - Evaluate the test infrastructure for speed and reliability
   - Identify manual testing procedures that should be automated
   - Check for missing input validation that causes runtime errors

5. REMEDIATION PLAN
   - Rank all debt items by ROI: (impact on velocity) / (effort to fix)
   - Group items into themes that can be tackled together
   - Create a phased plan: quick wins (< 1 day), sprints (1-2 weeks), projects (1+ months)
   - Identify debt that can be paid down incrementally during feature work
   - Recommend specific refactoring patterns for each major item
   - Define "done" criteria for each remediation task

6. PREVENTION FRAMEWORK
   - Propose coding standards that prevent the most common debt types
   - Recommend automated tooling (linters, formatters, pre-commit hooks) to enforce standards
   - Design a tech debt tracking system (labels, scores, sprint allocation)
   - Create a "tech debt budget" proposal for ongoing sprint allocation
   - Define review criteria that prevent new debt from entering the codebase
   - Establish quarterly debt review cadence with specific metrics to track

Present the audit as an executive summary with a debt-to-feature velocity ratio, followed by the detailed inventory and remediation plan. Make the business case for each high-priority item in terms the non-technical stakeholders understand.

Be specific to my situation. No generic filler.
