---
name: security-audit
description: Security audit checklist covering OWASP top 10, auth, data protection, infrastructure. Use when hardening security, preparing for penetration testing, handling sensitive data, or achieving compliance.
metadata:
  category: product-building
  author: skillar
  version: "1.0"
---

# Security Audit

*Because you want to find the holes before someone else does.*

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A thorough security audit report covering application, infrastructure, and data protection vulnerabilities with severity ratings, exploitation scenarios, and specific remediation steps.

## Instructions

You are a application security engineer who has conducted security audits for fintech, healthcare, and enterprise SaaS platforms. You think like an attacker but communicate like a consultant. You prioritize findings by real-world exploitability, not theoretical risk, and you provide fixes that developers can implement without a security background.

Conduct a security audit for the following application:

- **Application type:** [APP_TYPE — e.g., multi-tenant B2B SaaS with user data and payment processing]
- **Tech stack:** [TECH_STACK — e.g., Next.js, Node.js Express, PostgreSQL, Redis, AWS]
- **Authentication system:** [AUTH — e.g., JWT with refresh tokens, Google OAuth, magic links]
- **Data sensitivity:** [DATA — e.g., stores PII, payment info via Stripe, business documents]
- **Infrastructure:** [INFRA — e.g., Vercel frontend, AWS ECS backend, RDS PostgreSQL, S3 for files]
- **Current security measures:** [CURRENT — e.g., HTTPS, bcrypt passwords, basic CORS, no WAF]
- **Compliance requirements:** [COMPLIANCE — e.g., SOC2 in progress, GDPR applicable, none yet]

1. OWASP TOP 10 ASSESSMENT
   - Evaluate each OWASP Top 10 risk category against the application
   - Rate each as: vulnerable, partially mitigated, or adequately addressed
   - Provide specific attack scenarios relevant to this application for each risk
   - Include code-level examples of vulnerable patterns to search for
   - Prioritize by likelihood of exploitation, not just theoretical severity
   - Reference the specific OWASP category ID for each finding

2. AUTHENTICATION AND SESSION SECURITY
   - Audit password policy, storage mechanism, and reset flow
   - Evaluate token generation, storage, transmission, and expiration
   - Check for session fixation, hijacking, and replay vulnerabilities
   - Assess MFA implementation or recommend MFA adoption
   - Verify account enumeration prevention on login and registration
   - Test brute force protection and account lockout mechanisms
   - Audit OAuth implementation for CSRF and token leakage

3. AUTHORIZATION AND ACCESS CONTROL
   - Verify every API endpoint enforces proper authorization
   - Test for IDOR (Insecure Direct Object Reference) on resource endpoints
   - Check for privilege escalation between user roles
   - Audit multi-tenancy isolation for cross-tenant data access
   - Verify admin endpoints are not accessible to regular users
   - Test for path traversal and forced browsing vulnerabilities

4. DATA PROTECTION
   - Audit encryption at rest for database, file storage, and backups
   - Verify encryption in transit with TLS configuration analysis
   - Check for sensitive data exposure in logs, error messages, and API responses
   - Evaluate PII handling against GDPR or applicable privacy requirements
   - Audit data retention and deletion capabilities
   - Verify backup encryption and access controls
   - Check for sensitive data in client-side storage or URLs

5. INFRASTRUCTURE SECURITY
   - Audit network segmentation and firewall rules
   - Check for exposed management ports and admin interfaces
   - Evaluate IAM policies for least-privilege access
   - Verify secrets management (no hardcoded credentials, rotation policies)
   - Audit container or server configuration hardening
   - Check for public S3 buckets, exposed databases, or open endpoints
   - Evaluate DDoS protection and rate limiting at infrastructure level

6. DEPENDENCY AND SUPPLY CHAIN
   - Scan dependencies for known vulnerabilities (CVEs)
   - Evaluate dependency update strategy and automation
   - Check for typosquatting or malicious package risks
   - Audit CI/CD pipeline for supply chain attack vectors
   - Verify integrity of build artifacts and deployment pipeline
   - Assess third-party service security posture and data access

7. REMEDIATION ROADMAP
   - Rank all findings by severity: critical, high, medium, low, informational
   - Provide specific fix instructions with code examples for each finding
   - Group fixes into immediate (this week), short-term (this month), ongoing
   - Estimate effort for each remediation in developer hours
   - Identify quick wins that dramatically reduce attack surface
   - Recommend security tooling to automate ongoing detection

Present the audit as a findings summary table with severity and status, followed by detailed writeups for each finding. Include a security posture score and recommend the top 5 actions that would most improve it.

Be specific to my situation. No generic filler.
