---
name: scalability-roadmap
description: Creates scaling plan from MVP to 100k users with infrastructure decisions. Use when planning for growth, hitting performance limits, preparing for traffic spikes, or designing for scale.
metadata:
  category: product-building
  author: skillar
  version: "1.0"
---

# Scalability Roadmap

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A phased scaling plan with specific infrastructure upgrades, architectural changes, and cost projections at each growth milestone from MVP through 100k users.

## Instructions

You are a platform engineer who has scaled applications from a single server to distributed systems serving millions. You know that premature optimization kills startups and that scaling too late kills products. You design roadmaps where each scaling investment is triggered by measurable signals, not speculation.

Create a scalability roadmap for the following product:

- **Product type:** [PRODUCT_TYPE — e.g., real-time collaboration tool with document editing and chat]
- **Current architecture:** [CURRENT — e.g., Next.js on Vercel, Node.js API on Railway, PostgreSQL single instance, no caching]
- **Current scale:** [CURRENT_SCALE — e.g., 500 users, 2k requests/minute at peak, 10GB database]
- **Growth targets:** [TARGETS — e.g., 5k users in 3 months, 25k in 6 months, 100k in 12 months]
- **Traffic pattern:** [PATTERN — e.g., business hours heavy, real-time WebSocket connections, file uploads]
- **Budget trajectory:** [BUDGET — e.g., $200/month now, $2k/month at 25k users, $10k/month at 100k]
- **Team growth:** [TEAM — e.g., 2 devs now, hiring 2 more at 25k users, dedicated DevOps at 50k]
- **Known bottlenecks:** [BOTTLENECKS — e.g., database CPU at 80%, slow search queries, file upload timeouts]

1. CURRENT STATE ASSESSMENT
   - Profile the current bottlenecks with specific metrics and thresholds
   - Identify the component that will fail first as traffic increases
   - Calculate the theoretical maximum capacity of each layer
   - Assess which parts of the architecture are horizontally scalable already
   - Identify single points of failure and their blast radius
   - Benchmark the current cost-per-user and how it trends with growth

2. PHASE 1: 0 TO 5K USERS
   - List specific infrastructure changes needed to handle 5x current load
   - Add caching layer with specific cache targets and invalidation strategy
   - Optimize the top 5 database queries that will become problems first
   - Implement connection pooling and database read optimization
   - Add CDN for static assets and configure cache headers
   - Set up autoscaling rules for compute resources
   - Estimate monthly infrastructure cost at this tier

3. PHASE 2: 5K TO 25K USERS
   - Evaluate database read replicas or connection scaling strategy
   - Design background job infrastructure for async processing
   - Implement search infrastructure if full-text search degrades
   - Add application-level caching (Redis) for expensive computations
   - Evaluate microservice extraction for independently scaling components
   - Design rate limiting and abuse prevention for public endpoints
   - Plan for multi-region deployment if user base is geographically distributed
   - Estimate monthly infrastructure cost at this tier

4. PHASE 3: 25K TO 100K USERS
   - Design database sharding or partitioning strategy if needed
   - Implement message queue for decoupling services under load
   - Evaluate specialized databases for specific workloads (time-series, graph, search)
   - Design WebSocket scaling strategy for real-time features
   - Plan for stateless application architecture with external session store
   - Implement distributed caching with consistent hashing
   - Design the deployment pipeline for zero-downtime at this scale
   - Estimate monthly infrastructure cost at this tier

5. SCALING TRIGGERS AND SIGNALS
   - Define the exact metrics that trigger each scaling phase
   - Set up monitoring dashboards for capacity planning signals
   - Create alerting rules for approaching capacity limits
   - Design load testing strategy to validate each phase before traffic arrives
   - Build capacity projection model based on user growth rate
   - Identify which scaling decisions are reversible and which are commitments

6. COST OPTIMIZATION
   - Map infrastructure cost at each user milestone in a summary table
   - Identify the most expensive components and their cost drivers
   - Recommend reserved instances, committed use discounts, or alternative providers
   - Design cost alerting to prevent unexpected bills during traffic spikes
   - Calculate cost-per-user target at each phase and flag when it trends wrong
   - Identify where architecture choices trade higher cost for operational simplicity

Deliver the roadmap as a milestone timeline with trigger conditions, followed by detailed implementation guides for each phase. Include a cost projection table and architecture diagrams for current state, mid-scale, and full-scale configurations. Every recommendation must include "do this when X, not before."

Be specific to my situation. No generic filler.
