---
name: performance-audit
description: Audits app performance and provides optimization roadmap. Use when diagnosing slow pages, reducing load times, optimizing queries, or improving Core Web Vitals.
metadata:
  category: product-building
  author: skillar
  version: "1.0"
---

# Performance Audit

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A prioritized performance audit report identifying bottlenecks across frontend, backend, and infrastructure, with specific fixes ranked by effort-to-impact ratio.

## Instructions

You are a performance engineer who has optimized applications from 12-second load times down to sub-second. You profile before guessing, measure after fixing, and know that the biggest wins usually come from eliminating unnecessary work rather than making work faster.

Audit the performance of the following application:

- **Application type:** [APP_TYPE — e.g., React SPA with Node.js API, server-rendered Next.js app]
- **Current performance issues:** [ISSUES — e.g., 4s initial load, slow dashboard with 10k rows, API timeouts]
- **Tech stack:** [TECH_STACK — e.g., Next.js, Express, PostgreSQL, Redis, deployed on Vercel + AWS]
- **Traffic profile:** [TRAFFIC — e.g., 5k DAU, peak at 500 concurrent, mostly read-heavy]
- **Key user flows:** [FLOWS — e.g., login → dashboard → report generation → export]
- **Current metrics (if known):** [METRICS — e.g., LCP 3.2s, TTFB 800ms, largest API response 2.1s]
- **Infrastructure setup:** [INFRA — e.g., single region, no CDN, 2GB database, no caching layer]

1. FRONTEND PERFORMANCE
   - Audit bundle size and identify the largest dependencies to tree-shake or replace
   - Check for render-blocking resources and recommend critical CSS strategy
   - Evaluate image optimization (formats, sizing, lazy loading, CDN delivery)
   - Identify unnecessary client-side JavaScript and hydration overhead
   - Review component re-render patterns and memoization opportunities
   - Assess Core Web Vitals (LCP, CLS, INP) and specific fixes for each

2. API AND BACKEND PERFORMANCE
   - Identify the 5 slowest API endpoints and root cause each
   - Audit database queries for N+1 patterns, missing indexes, and full table scans
   - Evaluate connection pooling configuration and connection limits
   - Check for synchronous operations that should be async or queued
   - Review serialization overhead for large response payloads
   - Assess middleware chain for unnecessary processing on hot paths

3. DATABASE OPTIMIZATION
   - Analyze slow query log and recommend index additions
   - Identify queries that need pagination or cursor-based loading
   - Evaluate schema for denormalization opportunities on read-heavy tables
   - Check for lock contention on write-heavy tables
   - Recommend query result caching strategy with invalidation rules
   - Assess vacuum, analyze, and maintenance configurations

4. CACHING STRATEGY
   - Design cache layers: browser, CDN, application, database
   - Specify cache-control headers for static assets, API responses, and HTML
   - Recommend application-level caching with Redis for expensive computations
   - Define cache invalidation strategy that prevents stale data
   - Identify which API responses benefit most from caching
   - Calculate expected hit rates and load reduction

5. INFRASTRUCTURE OPTIMIZATION
   - Evaluate server sizing and recommend right-sizing or autoscaling
   - Assess CDN configuration for static assets and edge caching
   - Check DNS resolution, TLS handshake, and connection reuse
   - Recommend geographic distribution if users are globally distributed
   - Evaluate containerization overhead and cold start impact
   - Assess monitoring blind spots in current observability setup

6. PRIORITIZED ACTION PLAN
   - Rank all findings by impact (high/medium/low) and effort (hours/days/weeks)
   - Identify the top 5 quick wins achievable in one sprint
   - Define target metrics for each optimization with measurement method
   - Create a phased roadmap: immediate, next month, next quarter
   - Specify how to validate each fix with before/after benchmarks

Deliver the audit as a findings table sorted by priority, followed by detailed analysis and fix instructions for each item. Include estimated performance improvement percentages where possible.

Be specific to my situation. No generic filler.
