---
name: no-code-prototype
description: Plans a no-code prototype using Bubble, Webflow, Airtable to validate before coding. Use when testing ideas fast, building without code, creating clickable prototypes, or validating demand.
metadata:
  category: product-building
  author: skillar
  version: "1.0"
---

# No-Code Prototype

> **Usage:** Copy this skill into Claude → replace [BRACKETS] with your details → get polished output.

## What You Get
A complete no-code prototype plan with specific tool selections, data structure, page layouts, workflow automations, and step-by-step build instructions to validate your idea in days, not months.

## Instructions

You are a no-code architect who has helped 50+ founders validate product ideas before writing a single line of code. You know every major no-code platform's strengths, limitations, and pricing traps. You build prototypes that look real enough to charge money and collect real user feedback.

Plan a no-code prototype for the following product idea:

- **Product idea:** [PRODUCT_IDEA — e.g., marketplace connecting freelance designers with small businesses]
- **Core value proposition:** [VALUE_PROP — e.g., businesses post design briefs, designers bid, platform handles payment]
- **Key user flows:** [USER_FLOWS — e.g., business posts job → designers apply → business selects → work delivered → payment released]
- **User types:** [USER_TYPES — e.g., business owners, freelance designers, admin]
- **What you want to validate:** [VALIDATION_GOAL — e.g., will businesses pay $50/posting? will designers bid within 24h?]
- **Builder's no-code experience:** [EXPERIENCE — e.g., used Airtable, never used Bubble]
- **Budget for tools:** [BUDGET — e.g., $0-100/month]
- **Timeline:** [TIMELINE — e.g., working prototype in 2 weeks]

1. TOOL SELECTION
   - Recommend primary platform (Bubble, Webflow, Softr, Glide) based on product type
   - Specify supporting tools for database (Airtable, Xano), auth, payments, email
   - Map each product requirement to the specific tool that handles it
   - Compare total monthly cost across 2-3 tool combinations
   - Flag features that are impossible in no-code and identify workarounds
   - Recommend the combination that maximizes speed with minimum learning curve

2. DATA STRUCTURE
   - Design the database tables/collections for the chosen platform
   - Define fields, field types, and relationships between tables
   - Set up lookup and rollup fields for computed data
   - Plan for user-generated content storage and file uploads
   - Design views and filters for different user roles
   - Include sample data entries to visualize the structure

3. PAGE AND SCREEN DESIGN
   - List every page/screen the prototype needs with purpose
   - Sketch the layout structure for each page (header, sections, CTAs)
   - Specify which template or component to start from on the platform
   - Design the navigation flow between pages
   - Plan responsive behavior for mobile access
   - Identify which pages are public vs authenticated

4. WORKFLOW AUTOMATIONS
   - Map every automated trigger (new signup, form submit, payment, status change)
   - Design email notification workflows for key events
   - Set up payment collection flow using Stripe integration
   - Create admin notification workflows for monitoring
   - Handle status transitions (pending → approved → completed)
   - Build scheduled automations for reminders and follow-ups

5. USER AUTHENTICATION AND PERMISSIONS
   - Set up signup and login flows for each user type
   - Configure role-based page access and data visibility
   - Design onboarding flow for first-time users
   - Handle password reset and account management
   - Restrict data editing to record owners only

6. VALIDATION EXPERIMENT
   - Define the specific metric that proves or disproves your hypothesis
   - Set up analytics tracking for key conversion events
   - Design the landing page that drives prototype signups
   - Plan the user recruitment strategy (where to find first 20 users)
   - Create a feedback collection mechanism built into the prototype
   - Define the decision criteria: what results mean build, pivot, or kill

Deliver the plan as a day-by-day build schedule with specific tasks, followed by detailed platform configuration instructions for each component. Include links to relevant templates or tutorials for the recommended platform.

Be specific to my situation. No generic filler.
